/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class IEExplosion
extends Explosion {
    public float dropChance = 1.0f / this.size;
    private int blockDestroyInt = 0;
    public int blocksPerTick = 8;
    public boolean isExplosionFinished = false;

    public IEExplosion(World world, Entity igniter, double x, double y, double z, float size, boolean isFlaming, boolean isSmoking) {
        super(world, igniter, x, y, z, size, isFlaming, isSmoking);
    }

    public IEExplosion setDropChance(float chance) {
        this.dropChance = chance;
        return this;
    }

    public void doExplosionTick() {
        int max = Math.min(this.blockDestroyInt + this.blocksPerTick, this.affectedBlockPositions.size());
        while (this.blockDestroyInt < max) {
            BlockPos pos = (BlockPos)this.affectedBlockPositions.get(this.blockDestroyInt);
            IBlockState state = this.world.getBlockState(pos);
            Block block = state.getBlock();
            double d0 = (float)pos.getX() + Utils.RAND.nextFloat();
            double d1 = (float)pos.getY() + Utils.RAND.nextFloat();
            double d2 = (float)pos.getZ() + Utils.RAND.nextFloat();
            double d3 = d0 - this.x;
            double d4 = d1 - this.y;
            double d5 = d2 - this.z;
            double d6 = MathHelper.sqrt((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.size + 0.1);
            this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.x * 1.0) / 2.0, (d1 + this.y * 1.0) / 2.0, (d2 + this.z * 1.0) / 2.0, d3 *= (d7 *= (double)(Utils.RAND.nextFloat() * Utils.RAND.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
            this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            if (state.getMaterial() != Material.AIR) {
                if (block.canDropFromExplosion((Explosion)this)) {
                    block.dropBlockAsItemWithChance(this.world, pos, this.world.getBlockState(pos), this.dropChance, 0);
                }
                block.onBlockExploded(this.world, pos, (Explosion)this);
            }
            ++this.blockDestroyInt;
        }
        if (this.blockDestroyInt >= this.affectedBlockPositions.size()) {
            this.isExplosionFinished = true;
        }
    }

    public void doExplosionA() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + Utils.RAND.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.world.getBlockState(blockpos);
                        if (iblockstate.getMaterial() != Material.AIR) {
                            float f2 = this.exploder != null ? this.exploder.getExplosionResistance((Explosion)this, this.world, blockpos, iblockstate) : iblockstate.getBlock().getExplosionResistance(this.world, blockpos, null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.canExplosionDestroyBlock((Explosion)this, this.world, blockpos, iblockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        Collections.sort(this.affectedBlockPositions, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos arg0, BlockPos arg1) {
                return Double.compare(arg0.distanceSq(IEExplosion.this.x, IEExplosion.this.y, IEExplosion.this.z), arg1.distanceSq(IEExplosion.this.x, IEExplosion.this.y, IEExplosion.this.z));
            }
        });
        float f3 = this.size * 2.0f;
        int k1 = MathHelper.floor((double)(this.x - (double)f3 - 1.0));
        int l1 = MathHelper.floor((double)(this.x + (double)f3 + 1.0));
        int i2 = MathHelper.floor((double)(this.y - (double)f3 - 1.0));
        int i1 = MathHelper.floor((double)(this.y + (double)f3 + 1.0));
        int j2 = MathHelper.floor((double)(this.z - (double)f3 - 1.0));
        int j1 = MathHelper.floor((double)(this.z + (double)f3 + 1.0));
        List list = this.world.getEntitiesWithinAABBExcludingEntity(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3 = new Vec3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.isImmuneToExplosions() || !((d12 = entity.getDistance(this.x, this.y, this.z) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.sqrt((double)((d5 = entity.posX - this.x) * d5 + (d7 = entity.posY + (double)entity.getEyeHeight() - this.y) * d7 + (d9 = entity.posZ - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.world.getBlockDensity(vec3, entity.getEntityBoundingBox());
            double d10 = (1.0 - d12) * d14;
            entity.attackEntityFrom(DamageSource.causeExplosionDamage((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 8.0 * (double)f3 + 1.0)));
            double d11 = entity instanceof EntityLivingBase ? EnchantmentProtection.getBlastDamageReduction((EntityLivingBase)((EntityLivingBase)entity), (double)d10) : d10;
            entity.motionX += d5 * d11;
            entity.motionY += d7 * d11;
            entity.motionZ += d9 * d11;
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).capabilities.disableDamage) continue;
            this.playerKnockbackMap.put((EntityPlayer)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        this.world.playSound(this.x, this.y, this.z, SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.NEUTRAL, 4.0f, (1.0f + (Utils.RAND.nextFloat() - Utils.RAND.nextFloat()) * 0.2f) * 0.7f, true);
        if (this.size >= 2.0f && this.damagesTerrain) {
            this.world.spawnParticle(EnumParticleTypes.EXPLOSION_HUGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        }
        EventHandler.currentExplosions.add(this);
    }
}

