/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxConnection;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxContainerItem;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    static HashMap<Item, Boolean> reverseInsertion = new HashMap();

    public static boolean isFluxItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.getItem() instanceof IFluxContainerItem) {
            return true;
        }
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public static int getEnergyStored(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.getItem()).getEnergyStored(stack);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored();
        }
        return 0;
    }

    public static int getMaxEnergyStored(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.getItem()).getMaxEnergyStored(stack);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getMaxEnergyStored();
        }
        return 0;
    }

    public static int insertFlux(ItemStack stack, int energy, boolean simulate) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.getItem()).receiveEnergy(stack, energy, simulate);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static int extractFlux(ItemStack stack, int energy, boolean simulate) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem() instanceof IFluxContainerItem) {
            return ((IFluxContainerItem)stack.getItem()).extractEnergy(stack, energy, simulate);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energy, simulate);
        }
        return 0;
    }

    public static int forceExtractFlux(ItemStack stack, int energy, boolean simulate) {
        if (stack.isEmpty()) {
            return 0;
        }
        Boolean b = reverseInsertion.get(stack.getItem());
        if (b == Boolean.TRUE) {
            int stored = EnergyHelper.getEnergyStored(stack);
            EnergyHelper.insertFlux(stack, -energy, simulate);
            return stored - EnergyHelper.getEnergyStored(stack);
        }
        int drawn = EnergyHelper.extractFlux(stack, energy, simulate);
        if (b == null) {
            int stored = EnergyHelper.getEnergyStored(stack);
            EnergyHelper.insertFlux(stack, -energy, simulate);
            drawn = stored - EnergyHelper.getEnergyStored(stack);
            reverseInsertion.put(stack.getItem(), drawn > 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return drawn;
    }

    public static boolean isFluxReceiver(TileEntity tile, EnumFacing facing) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IFluxReceiver && ((IFluxReceiver)tile).canConnectEnergy(facing)) {
            return true;
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)).canReceive();
        }
        return false;
    }

    public static int insertFlux(TileEntity tile, EnumFacing facing, int energy, boolean simulate) {
        if (tile == null) {
            return 0;
        }
        if (tile instanceof IFluxReceiver && ((IFluxReceiver)tile).canConnectEnergy(facing)) {
            return ((IFluxReceiver)tile).receiveEnergy(facing, energy, simulate);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)).receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static class ItemEnergyStorage
    implements IEnergyStorage {
        ItemStack stack;
        IIEEnergyItem ieEnergyItem;

        public ItemEnergyStorage(ItemStack item) {
            assert (item.getItem() instanceof IIEEnergyItem);
            this.stack = item;
            this.ieEnergyItem = (IIEEnergyItem)item.getItem();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.ieEnergyItem.receiveEnergy(this.stack, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.ieEnergyItem.extractEnergy(this.stack, maxExtract, simulate);
        }

        public int getEnergyStored() {
            return this.ieEnergyItem.getEnergyStored(this.stack);
        }

        public int getMaxEnergyStored() {
            return this.ieEnergyItem.getMaxEnergyStored(this.stack);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static interface IIEEnergyItem
    extends IFluxContainerItem {
        @Override
        default public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
            return ItemNBTHelper.insertFluxItem(container, energy, this.getMaxEnergyStored(container), simulate);
        }

        @Override
        default public int extractEnergy(ItemStack container, int energy, boolean simulate) {
            return ItemNBTHelper.extractFluxFromItem(container, energy, simulate);
        }

        @Override
        default public int getEnergyStored(ItemStack container) {
            return ItemNBTHelper.getFluxStoredInItem(container);
        }
    }

    public static class IEForgeEnergyWrapper
    implements IEnergyStorage {
        final IIEInternalFluxConnector fluxHandler;
        public final EnumFacing side;

        public IEForgeEnergyWrapper(IIEInternalFluxConnector fluxHandler, EnumFacing side) {
            this.fluxHandler = fluxHandler;
            this.side = side;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).receiveEnergy(this.side, maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).extractEnergy(this.side, maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getEnergyStored(this.side);
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getMaxEnergyStored(this.side);
            }
            return 0;
        }

        public boolean canExtract() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getFluxStorage().getLimitExtract() > 0;
            }
            return false;
        }

        public boolean canReceive() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getFluxStorage().getLimitReceive() > 0;
            }
            return false;
        }

        public static IEForgeEnergyWrapper[] getDefaultWrapperArray(IIEInternalFluxConnector handler) {
            return new IEForgeEnergyWrapper[]{new IEForgeEnergyWrapper(handler, EnumFacing.DOWN), new IEForgeEnergyWrapper(handler, EnumFacing.UP), new IEForgeEnergyWrapper(handler, EnumFacing.NORTH), new IEForgeEnergyWrapper(handler, EnumFacing.SOUTH), new IEForgeEnergyWrapper(handler, EnumFacing.WEST), new IEForgeEnergyWrapper(handler, EnumFacing.EAST)};
        }
    }

    public static interface IIEInternalFluxConnector
    extends IFluxConnection {
        @Nonnull
        public IEEnums.SideConfig getEnergySideConfig(@Nullable EnumFacing var1);

        @Override
        default public boolean canConnectEnergy(@Nullable EnumFacing fd) {
            return this.getEnergySideConfig(fd) != IEEnums.SideConfig.NONE;
        }

        public IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing var1);
    }

    public static interface IIEInternalFluxHandler
    extends IIEInternalFluxConnector,
    IFluxReceiver,
    IFluxProvider {
        @Nonnull
        public FluxStorage getFluxStorage();

        default public void postEnergyTransferUpdate(int energy, boolean simulate) {
        }

        @Override
        default public int extractEnergy(@Nullable EnumFacing fd, int amount, boolean simulate) {
            if (((TileEntity)this).getWorld().isRemote || this.getEnergySideConfig(fd) != IEEnums.SideConfig.OUTPUT) {
                return 0;
            }
            int r = this.getFluxStorage().extractEnergy(amount, simulate);
            this.postEnergyTransferUpdate(-r, simulate);
            return r;
        }

        @Override
        default public int getEnergyStored(@Nullable EnumFacing fd) {
            return this.getFluxStorage().getEnergyStored();
        }

        @Override
        default public int getMaxEnergyStored(@Nullable EnumFacing fd) {
            return this.getFluxStorage().getMaxEnergyStored();
        }

        @Override
        default public int receiveEnergy(@Nullable EnumFacing fd, int amount, boolean simulate) {
            if (((TileEntity)this).getWorld().isRemote || this.getEnergySideConfig(fd) != IEEnums.SideConfig.INPUT) {
                return 0;
            }
            int r = this.getFluxStorage().receiveEnergy(amount, simulate);
            this.postEnergyTransferUpdate(r, simulate);
            return r;
        }
    }
}

