/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemWireCoil
extends ItemIEBase
implements IWireCoil {
    public ItemWireCoil() {
        super("wirecoil", 64, "copper", "electrum", "hv", "rope", "structural", "redstone");
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        switch (stack.getItemDamage()) {
            default: {
                return WireType.COPPER;
            }
            case 1: {
                return WireType.ELECTRUM;
            }
            case 2: {
                return WireType.STEEL;
            }
            case 3: {
                return WireType.STRUCTURE_ROPE;
            }
            case 4: {
                return WireType.STRUCTURE_STEEL;
            }
            case 5: 
        }
        return WireType.REDSTONE;
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int[] link;
        if (stack.getItemDamage() == 5) {
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.coil.redstone", (Object[])new Object[0]));
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.coil.construction1", (Object[])new Object[0]));
        } else if (stack.getItemDamage() > 2) {
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.coil.construction0", (Object[])new Object[0]));
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.coil.construction1", (Object[])new Object[0]));
        }
        if (stack.getTagCompound() != null && stack.getTagCompound().hasKey("linkingPos") && (link = stack.getTagCompound().getIntArray("linkingPos")) != null && link.length > 3) {
            list.add(I18n.format((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            ItemStack stack = player.getHeldItem(hand);
            TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
            WireType wire = this.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, target);
            if (!((tileEntity = world.getTileEntity(masterPos)) instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return EnumActionResult.PASS;
            }
            if (!((IImmersiveConnectable)tileEntity).canConnectCable(wire, target)) {
                if (!world.isRemote) {
                    player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.wrongCable", new Object[0]));
                }
                return EnumActionResult.FAIL;
            }
            if (!world.isRemote) {
                if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                    ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.provider.getDimension(), masterPos.getX(), masterPos.getY(), masterPos.getZ()});
                    NBTTagCompound targetNbt = new NBTTagCompound();
                    target.writeToNBT(targetNbt);
                    ItemNBTHelper.setTagCompound(stack, "targettingInfo", targetNbt);
                } else {
                    WireType type = this.getWireType(stack);
                    int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
                    BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                    TileEntity tileEntityLinkingPos = world.getTileEntity(linkPos);
                    int distanceSq = (int)Math.ceil(linkPos.distanceSq((Vec3i)masterPos));
                    if (array[0] != world.provider.getDimension()) {
                        player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.wrongDimension", new Object[0]));
                    } else if (linkPos.equals((Object)masterPos)) {
                        player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.sameConnection", new Object[0]));
                    } else if (distanceSq > type.getMaxLength() * type.getMaxLength()) {
                        player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.tooFar", new Object[0]));
                    } else {
                        TargetingInfo targetLink = TargetingInfo.readFromNBT(ItemNBTHelper.getTagCompound(stack, "targettingInfo"));
                        if (!(tileEntityLinkingPos instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(wire, targetLink)) {
                            player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.invalidPoint", new Object[0]));
                        } else {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            boolean connectionExists = false;
                            Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(world, Utils.toCC(nodeHere));
                            if (outputs != null) {
                                for (ImmersiveNetHandler.Connection con : outputs) {
                                    if (!con.end.equals((Object)Utils.toCC(nodeLink))) continue;
                                    connectionExists = true;
                                }
                            }
                            if (connectionExists) {
                                player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.connectionExists", new Object[0]));
                            } else {
                                boolean canSee;
                                Vec3d rtOff0 = nodeHere.getRaytraceOffset(nodeLink).addVector((double)masterPos.getX(), (double)masterPos.getY(), (double)masterPos.getZ());
                                Vec3d rtOff1 = nodeLink.getRaytraceOffset(nodeHere).addVector((double)linkPos.getX(), (double)linkPos.getY(), (double)linkPos.getZ());
                                HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                                ignore.addAll(nodeHere.getIgnored(nodeLink));
                                ignore.addAll(nodeLink.getIgnored(nodeHere));
                                boolean bl = canSee = Utils.rayTraceForFirst(rtOff0, rtOff1, world, ignore) == null;
                                if (canSee) {
                                    ImmersiveNetHandler.INSTANCE.addConnection(world, Utils.toCC(nodeHere), Utils.toCC(nodeLink), (int)Math.sqrt(distanceSq), type);
                                    nodeHere.connectCable(type, target, nodeLink);
                                    nodeLink.connectCable(type, targetLink, nodeHere);
                                    IESaveData.setDirty(world.provider.getDimension());
                                    Utils.unlockIEAdvancement(player, "main/connect_wire");
                                    if (!player.capabilities.isCreativeMode) {
                                        stack.shrink(1);
                                    }
                                    ((TileEntity)nodeHere).markDirty();
                                    world.addBlockEvent(masterPos, ((TileEntity)nodeHere).getBlockType(), -1, 0);
                                    IBlockState state = world.getBlockState(masterPos);
                                    world.notifyBlockUpdate(masterPos, state, state, 3);
                                    ((TileEntity)nodeLink).markDirty();
                                    world.addBlockEvent(linkPos, ((TileEntity)nodeLink).getBlockType(), -1, 0);
                                    state = world.getBlockState(linkPos);
                                    world.notifyBlockUpdate(linkPos, state, state, 3);
                                } else {
                                    player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.warning.cantSee", new Object[0]));
                                }
                            }
                        }
                    }
                    ItemNBTHelper.remove(stack, "linkingPos");
                    ItemNBTHelper.remove(stack, "targettingInfo");
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

