/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemToolUpgrade
extends ItemIEBase
implements IUpgrade {
    public ItemToolUpgrade() {
        super("toolupgrade", 1, ToolUpgrades.parse());
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.getItemDamage() < this.getSubNames().length) {
            String[] flavour;
            for (String s : flavour = ImmersiveEngineering.proxy.splitStringOnWidth(I18n.format((String)("desc.immersiveengineering.flavour.toolupgrade." + this.getSubNames()[stack.getItemDamage()]), (Object[])new Object[0]), 200)) {
                list.add(s);
            }
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return ToolUpgrades.get(stack.getMetadata()).stackSize;
    }

    @Override
    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return ToolUpgrades.get(upgrade.getMetadata()).toolset;
    }

    @Override
    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate check = ToolUpgrades.get(upgrade.getMetadata()).applyCheck;
        if (check != null && target.getItem() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    @Override
    public void applyUpgrades(ItemStack target, ItemStack upgrade, NBTTagCompound modifications) {
        ToolUpgrades.get(upgrade.getMetadata()).function.accept(upgrade, modifications);
    }

    public static enum ToolUpgrades {
        DRILL_WATERPROOF((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.setBoolean("waterproof", true)),
        DRILL_LUBE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.setBoolean("oiled", true)),
        DRILL_DAMAGE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), 3, (upgrade, modifications) -> {
            ItemNBTHelper.modifyFloat(modifications, "speed", (float)upgrade.getCount() * 2.0f);
            ItemNBTHelper.modifyInt(modifications, "damage", upgrade.getCount());
        }),
        DRILL_CAPACITY((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL", (Object)"CHEMTHROWER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.getItem()).getUpgrades((ItemStack)target).hasKey("multitank"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "capacity", 2000)),
        REVOLVER_BAYONET((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> ItemNBTHelper.modifyFloat(modifications, "melee", 6.0f)),
        REVOLVER_MAGAZINE((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.getItem()).getUpgrades((ItemStack)target).hasKey("bullets"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "bullets", 6)),
        REVOLVER_ELECTRO((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> modifications.setBoolean("electro", true)),
        CHEMTHROWER_FOCUS((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), (upgrade, modifications) -> modifications.setBoolean("focus", true)),
        RAILGUN_SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN"), (upgrade, modifications) -> modifications.setBoolean("scope", true)),
        RAILGUN_CAPACITORS((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN"), (upgrade, modifications) -> modifications.setFloat("speed", 1.0f)),
        SHIELD_FLASH((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.setBoolean("flash", true)),
        SHIELD_SHOCK((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.setBoolean("shock", true)),
        SHIELD_MAGNET((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.setBoolean("magnet", true)),
        CHEMTHROWER_MULTITANK((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.getItem()).getUpgrades((ItemStack)target).hasKey("capacity"), (upgrade, modifications) -> modifications.setBoolean("multitank", true));

        private ImmutableSet<String> toolset;
        private int stackSize = 1;
        private BiPredicate<ItemStack, ItemStack> applyCheck;
        private BiConsumer<ItemStack, NBTTagCompound> function;

        private ToolUpgrades(ImmutableSet<String> toolset, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, 1, function);
        }

        private ToolUpgrades(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, NBTTagCompound> function) {
            this(toolset, stackSize, null, function);
        }

        private ToolUpgrades(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, NBTTagCompound> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }

        static String[] parse() {
            String[] ret = new String[ToolUpgrades.values().length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = ToolUpgrades.values()[i].toString().toLowerCase(Locale.US);
            }
            return ret;
        }

        static ToolUpgrades get(int meta) {
            if (meta >= 0 && meta < ToolUpgrades.values().length) {
                return ToolUpgrades.values()[meta];
            }
            return DRILL_WATERPROOF;
        }
    }
}

