/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemSkyhook
extends ItemUpgradeableTool
implements ITool {
    public static HashMap<String, EntitySkylineHook> existingHooks = new HashMap();

    public ItemSkyhook() {
        super("skyhook", 1, "SKYHOOK", new String[0]);
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(I18n.format((String)"desc.immersiveengineering.flavour.skyhook", (Object[])new Object[0]));
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        super.onUpdate(stack, world, ent, slot, inHand);
        if (this.getUpgrades(stack).getBoolean("fallBoost")) {
            float dmg = (float)Math.ceil(ent.fallDistance / 5.0f);
            ItemNBTHelper.setFloat(stack, "fallDamageBoost", dmg);
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        TileEntity connector = null;
        double lastDist = 0.0;
        ImmersiveNetHandler.Connection line = null;
        double py = player.posY + (double)player.getEyeHeight();
        for (int xx = -2; xx <= 2; ++xx) {
            for (int zz = -2; zz <= 2; ++zz) {
                for (int yy = 0; yy <= 3; ++yy) {
                    ImmersiveNetHandler.Connection con;
                    TileEntity tile = world.getTileEntity(new BlockPos(player.posX + (double)xx, py + (double)yy, player.posZ + (double)zz));
                    if (tile == null || (con = SkylineHelper.getTargetConnection(world, tile.getPos(), (EntityLivingBase)player, null)) == null) continue;
                    double d = tile.getDistanceSq(player.posX, py, player.posZ);
                    if (connector != null && !(d < lastDist)) continue;
                    connector = tile;
                    lastDist = d;
                    line = con;
                }
            }
        }
        ItemStack stack = player.getHeldItem(hand);
        if (line != null && connector != null) {
            SkylineHelper.spawnHook(player, connector, line);
            player.setActiveHand(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public float getSkylineSpeed(ItemStack stack) {
        return 3.0f + this.getUpgrades(stack).getFloat("speed");
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase player, int ticks) {
        if (existingHooks.containsKey(player.getName())) {
            EntitySkylineHook hook = existingHooks.get(player.getName());
            hook.setDead();
            existingHooks.remove(player.getName());
        }
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 102, 42, "SKYHOOK", stack, true), new IESlot.Upgrades(container, inv, 1, 102, 22, "SKYHOOK", stack, true)};
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

