/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShaderBag
extends ItemIEBase {
    public ItemShaderBag() {
        super("shader_bag", 64, new String[0]);
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return ClientUtils.getFormattingColour(this.getRarity((ItemStack)stack).rarityColor);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.isInCreativeTab(tab)) {
            for (int i = ShaderRegistry.sortedRarityMap.size() - 1; i >= 0; --i) {
                EnumRarity rarity = ShaderRegistry.sortedRarityMap.get(i);
                ItemStack s = new ItemStack((Item)this);
                ItemNBTHelper.setString(s, "rarity", rarity.toString());
                list.add((Object)s);
            }
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return this.getRarity((ItemStack)stack).rarityName + " " + super.getItemStackDisplayName(stack);
    }

    public EnumRarity getRarity(ItemStack stack) {
        String r = ItemNBTHelper.getString(stack, "rarity");
        for (EnumRarity rarity : EnumRarity.values()) {
            if (!rarity.toString().equalsIgnoreCase(r)) continue;
            return rarity;
        }
        return EnumRarity.COMMON;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (!world.isRemote && ShaderRegistry.totalWeight.containsKey(stack.getRarity())) {
            String shader = ShaderRegistry.getRandomShader(player.getName(), player.getRNG(), stack.getRarity(), true);
            if (shader == null || shader.isEmpty()) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            ItemStack shaderItem = new ItemStack((Item)IEContent.itemShader);
            ItemNBTHelper.setString(shaderItem, "shader_name", shader);
            if (ShaderRegistry.sortedRarityMap.indexOf(ShaderRegistry.shaderRegistry.get(shader).getRarity()) <= ShaderRegistry.sortedRarityMap.indexOf(EnumRarity.EPIC) && ShaderRegistry.sortedRarityMap.indexOf(stack.getRarity()) >= ShaderRegistry.sortedRarityMap.indexOf(EnumRarity.COMMON)) {
                Utils.unlockIEAdvancement(player, "main/secret_luckofthedraw");
            }
            stack.shrink(1);
            if (stack.getCount() <= 0) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)shaderItem);
            }
            if (!player.inventory.addItemStackToInventory(shaderItem)) {
                player.dropItem(shaderItem, false, true);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

