/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.gui.ContainerRevolver;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemSpeedloader;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import blusunrize.immersiveengineering.common.util.network.MessageSpeedloaderSync;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemRevolver
extends ItemUpgradeableTool
implements IOBJModelCallback<ItemStack>,
ITool,
IEItemInterfaces.IGuiItem,
IEItemInterfaces.IBulletContainer {
    public static UUID speedModUUID = Utils.generateNewUUID();
    public HashMap<String, TextureAtlasSprite> revolverIcons = new HashMap();
    public TextureAtlasSprite revolverDefaultTexture;
    private static final Matrix4 matOpen = new Matrix4().translate(-0.625, 0.25, 0.0).rotate(-0.87266, 0.0, 0.0, 1.0);
    private static final Matrix4 matClose = new Matrix4().translate(-0.625, 0.25, 0.0);
    private static final Matrix4 matCylinder = new Matrix4().translate(0.0, 0.6875, 0.0);
    public static final ArrayListMultimap<String, SpecialRevolver> specialRevolvers = ArrayListMultimap.create();
    public static final Map<String, SpecialRevolver> specialRevolversByTag = new HashMap<String, SpecialRevolver>();

    public ItemRevolver() {
        super("revolver", 1, "REVOLVER", new String[0]);
    }

    public void stichRevolverTextures(TextureMap map) {
        this.revolverDefaultTexture = ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/revolver");
        for (String key : specialRevolversByTag.keySet()) {
            if (key.isEmpty() || ItemRevolver.specialRevolversByTag.get((Object)key).tag.isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            this.revolverIcons.put(key, ApiUtils.getRegisterSprite(map, "immersiveengineering:revolvers/revolver_" + key.substring(0, split).toLowerCase()));
        }
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 21;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 18, 80, 32, "REVOLVER", stack, true), new IESlot.Upgrades(container, inv, 19, 100, 32, "REVOLVER", stack, true)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return stack.getItemDamage() != 1;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged)) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.areItemStacksEqual((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return (ItemNBTHelper.hasKey(oldStack, "elite") || ItemNBTHelper.hasKey(newStack, "elite")) && !ItemNBTHelper.getString(oldStack, "elite").equals(ItemNBTHelper.getString(newStack, "elite"));
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new IEItemStackHandler(stack){
            final CapabilityShader.ShaderWrapper_Item shaders;
            {
                super(stack2);
                this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:revolver", stack);
            }

            @Override
            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
            }

            @Override
            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityShader.SHADER_CAPABILITY) {
                    return (T)this.shaders;
                }
                return super.getCapability(capability, facing);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.isInCreativeTab(tab)) {
            list.add((Object)new ItemStack((Item)this));
        }
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.getItemDamage() != 1) {
            String tag = this.getRevolverDisplayTag(stack);
            if (!tag.isEmpty()) {
                list.add(I18n.format((String)("desc.immersiveengineering.flavour.revolver." + tag), (Object[])new Object[0]));
            } else if (ItemNBTHelper.hasKey(stack, "flavour")) {
                list.add(I18n.format((String)("desc.immersiveengineering.flavour.revolver." + ItemNBTHelper.getString(stack, "flavour")), (Object[])new Object[0]));
            } else if (stack.getItemDamage() == 0) {
                list.add(I18n.format((String)"desc.immersiveengineering.flavour.revolver", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        String tag;
        if (stack.getItemDamage() != 1 && !(tag = this.getRevolverDisplayTag(stack)).isEmpty()) {
            return this.getUnlocalizedName() + "." + tag;
        }
        return super.getUnlocalizedName(stack);
    }

    public boolean isFull3D() {
        return true;
    }

    public Multimap getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double speed;
            double melee;
            if (this.getUpgrades(stack).getBoolean("fancyAnimation")) {
                multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", -2.0, 0));
            }
            if ((melee = this.getUpgrades(stack).getDouble("melee")) != 0.0) {
                multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", melee, 0));
                multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", (double)-2.4f, 0));
            }
            if ((speed = this.getUpgrades(stack).getDouble("speed")) != 0.0) {
                multimap.put((Object)SharedMonsterAttributes.MOVEMENT_SPEED.getName(), (Object)new AttributeModifier(speedModUUID, "Weapon modifier", speed, 1));
            }
        }
        return multimap;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        super.onUpdate(stack, world, ent, slot, inHand);
        if (ItemNBTHelper.hasKey(stack, "reload")) {
            int reload = ItemNBTHelper.getInt(stack, "reload") - 1;
            if (reload <= 0) {
                ItemNBTHelper.remove(stack, "reload");
            } else {
                ItemNBTHelper.setInt(stack, "reload", reload);
            }
        }
        if (ItemNBTHelper.hasKey(stack, "cooldown")) {
            int cooldown = ItemNBTHelper.getInt(stack, "cooldown") - 1;
            if (cooldown <= 0) {
                ItemNBTHelper.remove(stack, "cooldown");
            } else {
                ItemNBTHelper.setInt(stack, "cooldown", cooldown);
            }
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack revolver = player.getHeldItem(hand);
        if (!world.isRemote) {
            if (player.isSneaking()) {
                CommonProxy.openGuiForItem(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)revolver);
            }
            if (player.getCooledAttackStrength(1.0f) >= 1.0f) {
                if (this.getUpgrades(revolver).getBoolean("nerf")) {
                    world.playSound(null, player.posX, player.posY, player.posZ, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 1.0f, 0.6f);
                } else {
                    if (this.getShootCooldown(revolver) > 0 || ItemNBTHelper.hasKey(revolver, "reload")) {
                        return new ActionResult(EnumActionResult.PASS, (Object)revolver);
                    }
                    NonNullList bullets = this.getBullets(revolver);
                    if (this.isEmpty(revolver, false)) {
                        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
                            ItemStack stack = player.inventory.getStackInSlot(i);
                            if (!(stack.getItem() instanceof ItemSpeedloader) || ((ItemSpeedloader)stack.getItem()).isEmpty(stack)) continue;
                            for (ItemStack b : bullets) {
                                if (b.isEmpty()) continue;
                                world.spawnEntity((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, b));
                            }
                            this.setBullets(revolver, ((ItemSpeedloader)stack.getItem()).getContainedItems(stack));
                            ((ItemSpeedloader)stack.getItem()).setContainedItems(stack, (NonNullList<ItemStack>)NonNullList.withSize((int)8, (Object)ItemStack.EMPTY));
                            player.inventory.markDirty();
                            if (player instanceof EntityPlayerMP) {
                                ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSpeedloaderSync(i, hand), (EntityPlayerMP)player);
                            }
                            ItemNBTHelper.setInt(revolver, "reload", 60);
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)revolver);
                        }
                    }
                    if (!ItemNBTHelper.hasKey(revolver, "reload")) {
                        if (!((ItemStack)bullets.get(0)).isEmpty() && ((ItemStack)bullets.get(0)).getItem() instanceof ItemBullet && ItemNBTHelper.hasKey((ItemStack)bullets.get(0), "bullet")) {
                            String key = ItemNBTHelper.getString((ItemStack)bullets.get(0), "bullet");
                            BulletHandler.IBullet bullet = BulletHandler.getBullet(key);
                            if (bullet != null) {
                                Vec3d vec = player.getLookVec();
                                boolean electro = this.getUpgrades(revolver).getBoolean("electro");
                                int count = bullet.getProjectileCount(player);
                                if (count == 1) {
                                    EntityRevolvershot entBullet = this.getBullet(player, vec, vec, key, (ItemStack)bullets.get(0), electro);
                                    player.world.spawnEntity(bullet.getProjectile(player, (ItemStack)bullets.get(0), entBullet, electro));
                                } else {
                                    for (int i = 0; i < count; ++i) {
                                        Vec3d vecDir = vec.addVector(player.getRNG().nextGaussian() * 0.1, player.getRNG().nextGaussian() * 0.1, player.getRNG().nextGaussian() * 0.1);
                                        EntityRevolvershot entBullet = this.getBullet(player, vec, vecDir, key, (ItemStack)bullets.get(0), electro);
                                        player.world.spawnEntity(bullet.getProjectile(player, (ItemStack)bullets.get(0), entBullet, electro));
                                    }
                                }
                                bullets.set(0, (Object)bullet.getCasing((ItemStack)bullets.get(0)).copy());
                                SoundEvent sound = bullet.getSound();
                                if (sound == null) {
                                    sound = IESounds.revolverFire;
                                }
                                world.playSound(null, player.posX, player.posY, player.posZ, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            } else {
                                world.playSound(null, player.posX, player.posY, player.posZ, SoundEvents.BLOCK_NOTE_HAT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            }
                        } else {
                            world.playSound(null, player.posX, player.posY, player.posZ, SoundEvents.BLOCK_NOTE_HAT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        NonNullList cycled = NonNullList.withSize((int)this.getBulletCount(revolver), (Object)ItemStack.EMPTY);
                        for (int i = 1; i < cycled.size(); ++i) {
                            cycled.set(i - 1, bullets.get(i));
                        }
                        cycled.set(cycled.size() - 1, bullets.get(0));
                        this.setBullets(revolver, (NonNullList<ItemStack>)cycled);
                        player.inventory.markDirty();
                        ItemNBTHelper.setInt(revolver, "cooldown", this.getMaxShootCooldown(revolver));
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)revolver);
                    }
                }
            }
        } else if (!player.isSneaking() && revolver.getItemDamage() == 0) {
            return new ActionResult(this.getShootCooldown(revolver) > 0 || ItemNBTHelper.hasKey(revolver, "reload") ? EnumActionResult.PASS : EnumActionResult.SUCCESS, (Object)revolver);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)revolver);
    }

    EntityRevolvershot getBullet(EntityPlayer player, Vec3d vecSpawn, Vec3d vecDir, String type, ItemStack stack, boolean electro) {
        EntityRevolvershot bullet = new EntityRevolvershot(player.world, (EntityLivingBase)player, vecDir.x * 1.5, vecDir.y * 1.5, vecDir.z * 1.5, type, stack);
        bullet.motionX = vecDir.x * 2.0;
        bullet.motionY = vecDir.y * 2.0;
        bullet.motionZ = vecDir.z * 2.0;
        bullet.bulletElectro = electro;
        return bullet;
    }

    public int getShootCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, "cooldown");
    }

    public int getMaxShootCooldown(ItemStack stack) {
        return 15;
    }

    public boolean isEmpty(ItemStack stack, boolean allowCasing) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                if (b.isEmpty() || !(b.getItem() instanceof ItemBullet) || !allowCasing && !ItemNBTHelper.hasKey(b, "bullet")) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver, boolean remote) {
        if (!remote && this.isEmpty(revolver, true)) {
            remote = true;
        } else if (remote && !ItemNBTHelper.hasKey(revolver, "bullets")) {
            remote = false;
        }
        if (!remote) {
            return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getBulletCount(revolver)));
        }
        return Utils.readInventory(ItemNBTHelper.getTag(revolver).getTagList("bullets", 10), this.getBulletCount(revolver));
    }

    public void setBullets(ItemStack revolver, NonNullList<ItemStack> bullets) {
        int i;
        IItemHandlerModifiable inv = (IItemHandlerModifiable)revolver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        assert (inv != null);
        for (i = 0; i < 18; ++i) {
            inv.setStackInSlot(i, ItemStack.EMPTY);
        }
        for (i = 0; i < bullets.size(); ++i) {
            inv.setStackInSlot(i, (ItemStack)bullets.get(i));
        }
    }

    @Override
    public int getBulletCount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).getInteger("bullets");
    }

    @Override
    public NBTTagCompound getUpgradeBase(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "baseUpgrades");
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String material) {
        String tag = ItemNBTHelper.getString(stack, "elite");
        if (!tag.isEmpty()) {
            return this.revolverIcons.get(tag);
        }
        return this.revolverDefaultTexture;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        NBTTagCompound upgrades;
        SpecialRevolver r;
        if (group.equals("frame") || group.equals("cylinder") || group.equals("barrel") || group.equals("cosmetic_compensator")) {
            return true;
        }
        HashSet<String> render = new HashSet<String>();
        String tag = ItemNBTHelper.getString(stack, "elite");
        String flavour = ItemNBTHelper.getString(stack, "flavour");
        if (tag != null && !tag.isEmpty() && specialRevolversByTag.containsKey(tag)) {
            r = specialRevolversByTag.get(tag);
            if (r != null && r.renderAdditions != null) {
                for (String ss : r.renderAdditions) {
                    render.add(ss);
                }
            }
        } else if (flavour != null && !flavour.isEmpty() && specialRevolversByTag.containsKey(flavour) && (r = specialRevolversByTag.get(flavour)) != null && r.renderAdditions != null) {
            for (String ss : r.renderAdditions) {
                render.add(ss);
            }
        }
        if ((upgrades = this.getUpgrades(stack)).getInteger("bullets") > 0 && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (upgrades.getDouble("melee") > 0.0 && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (upgrades.getBoolean("electro")) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        return render.contains(group);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective, @Nullable EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            float f;
            boolean left;
            boolean main = (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) == (entity.getPrimaryHand() == EnumHandSide.RIGHT);
            boolean bl = left = cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            if (this.getUpgrades(stack).getBoolean("fancyAnimation") && main && (f = ((EntityPlayer)entity).getCooledAttackStrength(ClientUtils.mc().timer.renderPartialTicks)) < 1.0f) {
                float angle = f * -6.28318f;
                if (left) {
                    angle *= -1.0f;
                }
                perspective.translate(0.0, 1.5 - (double)f, 0.0);
                perspective.rotate(angle, 0.0, 0.0, 1.0);
            }
            ItemStack itemStack = stack = main ? entity.getHeldItemMainhand() : entity.getHeldItemOffhand();
            if (ItemNBTHelper.hasKey(stack, "reload")) {
                f = 3.0f - (float)ItemNBTHelper.getInt(stack, "reload") / 20.0f;
                if ((double)f > 0.35 && (double)f < 1.95) {
                    if ((double)f < 0.5) {
                        perspective.translate((0.35 - (double)f) * 2.0, 0.0, 0.0).rotate(2.64 * ((double)f - 0.35), 0.0, 0.0, left ? -1.0 : 1.0);
                    } else if ((double)f < 0.6) {
                        perspective.translate(((double)f - 0.5) * 6.0, (0.5 - (double)f) * 1.0, 0.0).rotate(0.87266, 0.0, 0.0, left ? -1.0 : 1.0);
                    } else if ((double)f < 1.7) {
                        perspective.translate(0.0, -0.6, 0.0).rotate(0.87266, 0.0, 0.0, left ? -1.0 : 1.0);
                    } else if ((double)f < 1.8) {
                        perspective.translate((1.8 - (double)f) * 6.0, ((double)f - 1.8) * 1.0, 0.0).rotate(0.87266, 0.0, 0.0, left ? -1.0 : 1.0);
                    } else {
                        perspective.translate((f - 1.95f) * 2.0f, 0.0, 0.0).rotate(2.64 * (1.95 - (double)f), 0.0, 0.0, left ? -1.0 : 1.0);
                    }
                }
            } else if (((EntityPlayer)entity).openContainer instanceof ContainerRevolver) {
                perspective.translate(left ? 0.4 : -0.4, 0.4, 0.0).rotate(0.87266, 0.0, 0.0, left ? -1.0 : 1.0);
            }
        }
        return perspective;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isDynamicGroup(ItemStack stack, String group) {
        return "frame".equals(group) || "cylinder".equals(group);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 dynamicChanges(ItemStack stack, String group, ItemCameraTransforms.TransformType cameraTransformType, @Nullable EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            boolean main = (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) == (entity.getPrimaryHand() == EnumHandSide.RIGHT);
            boolean left = cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            ItemStack itemStack = stack = main ? entity.getHeldItemMainhand() : entity.getHeldItemOffhand();
            if (ItemNBTHelper.hasKey(stack, "reload")) {
                float f = 3.0f - (float)ItemNBTHelper.getInt(stack, "reload") / 20.0f;
                if ("frame".equals(group)) {
                    if ((double)f < 0.35 || (double)f > 1.95) {
                        return matClose;
                    }
                    if ((double)f < 0.5) {
                        return new Matrix4().translate(-0.625, 0.25, 0.0).rotate(-2.64 * ((double)f - 0.35), 0.0, 0.0, 1.0);
                    }
                    if ((double)f < 1.8) {
                        return matOpen;
                    }
                    return new Matrix4().translate(-0.625, 0.25, 0.0).rotate(-2.64 * (1.95 - (double)f), 0.0, 0.0, 1.0);
                }
                if ((double)f > 2.5 && (double)f < 2.9) {
                    return new Matrix4().translate(0.0, 0.6875, 0.0).rotate(-15.70795 * ((double)f - 2.5), left ? -1.0 : 1.0, 0.0, 0.0);
                }
            } else if ("frame".equals(group) && ((EntityPlayer)entity).openContainer instanceof ContainerRevolver) {
                return matOpen;
            }
        }
        return "frame".equals(group) ? matClose : matCylinder;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform) {
        if (!Config.IEConfig.fancyItemAnimations && transform.isPresent() && ("frame".equals(group) || "cylinder".equals(group))) {
            Matrix4 mat = new Matrix4(transform.get().getMatrix());
            if ("frame".equals(group)) {
                mat.translate(-0.625, 0.25, 0.0);
            } else {
                mat.translate(0.0, 0.6875, 0.0);
            }
            return Optional.of(new TRSRTransformation(mat.toMatrix4f()));
        }
        return transform;
    }

    public String[] compileRender(ItemStack revolver) {
        NBTTagCompound upgrades;
        SpecialRevolver r;
        HashSet<String> render = new HashSet<String>();
        render.add("revolver_frame");
        render.add("barrel");
        render.add("cosmetic_compensator");
        String tag = ItemNBTHelper.getString(revolver, "elite");
        String flavour = ItemNBTHelper.getString(revolver, "flavour");
        if (tag != null && !tag.isEmpty() && specialRevolversByTag.containsKey(tag)) {
            r = specialRevolversByTag.get(tag);
            if (r != null && r.renderAdditions != null) {
                for (String ss : r.renderAdditions) {
                    render.add(ss);
                }
            }
        } else if (flavour != null && !flavour.isEmpty() && specialRevolversByTag.containsKey(flavour) && (r = specialRevolversByTag.get(flavour)) != null && r.renderAdditions != null) {
            for (String ss : r.renderAdditions) {
                render.add(ss);
            }
        }
        if ((upgrades = this.getUpgrades(revolver)).getInteger("bullets") > 0 && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (upgrades.getDouble("melee") > 0.0 && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (upgrades.getBoolean("electro")) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        return render.toArray(new String[render.size()]);
    }

    public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        ArrayList list;
        if (stack.isEmpty() || player == null) {
            return;
        }
        if (stack.getItemDamage() == 1) {
            return;
        }
        String uuid = player.getUniqueID().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = ItemNBTHelper.getString(stack, "elite");
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            ItemNBTHelper.remove(stack, "elite");
            ItemNBTHelper.remove(stack, "flavour");
            ItemNBTHelper.remove(stack, "baseUpgrades");
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            ItemNBTHelper.setString(stack, "elite", r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            ItemNBTHelper.setString(stack, "flavour", r.flavour);
        }
        NBTTagCompound baseUpgrades = new NBTTagCompound();
        for (Map.Entry<String, Object> e : r.baseUpgrades.entrySet()) {
            if (e.getValue() instanceof Boolean) {
                baseUpgrades.setBoolean(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                baseUpgrades.setInteger(e.getKey(), ((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof Float) {
                baseUpgrades.setDouble(e.getKey(), (double)((Float)e.getValue()).floatValue());
                continue;
            }
            if (e.getValue() instanceof Double) {
                baseUpgrades.setDouble(e.getKey(), ((Double)e.getValue()).doubleValue());
                continue;
            }
            if (!(e.getValue() instanceof String)) continue;
            baseUpgrades.setString(e.getKey(), (String)e.getValue());
        }
        ItemNBTHelper.setTagCompound(stack, "baseUpgrades", baseUpgrades);
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inv != null && !inv.getStackInSlot(18).isEmpty() && !inv.getStackInSlot(19).isEmpty()) {
            Utils.unlockIEAdvancement(player, "main/upgrade_revolver");
        }
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound ret = super.getNBTShareTag(stack);
        ret = ret == null ? new NBTTagCompound() : ret.copy();
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler != null) {
            NonNullList bullets = NonNullList.withSize((int)this.getBulletCount(stack), (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.getBulletCount(stack); ++i) {
                bullets.set(i, (Object)handler.getStackInSlot(i));
            }
            ret.setTag("bullets", (NBTBase)Utils.writeInventory((Collection<ItemStack>)bullets));
        }
        return ret;
    }

    @Override
    public int getGuiID(ItemStack stack) {
        return 65;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public static class SpecialRevolver {
        public final String[] uuid;
        public final String tag;
        public final String flavour;
        public final HashMap<String, Object> baseUpgrades;
        public final String[] renderAdditions;

        public SpecialRevolver(String[] uuid, String tag, String flavour, HashMap<String, Object> baseUpgrades, String[] renderAdditions) {
            this.uuid = uuid;
            this.tag = tag;
            this.flavour = flavour;
            this.baseUpgrades = baseUpgrades;
            this.renderAdditions = renderAdditions;
        }
    }
}

