/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemRailgun
extends ItemUpgradeableTool
implements EnergyHelper.IIEEnergyItem,
ZoomHandler.IZoomTool,
ITool,
IOBJModelCallback<ItemStack> {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public ItemRailgun() {
        super("railgun", 1, "RAILGUN", new String[0]);
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "RAILGUN", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "RAILGUN", stack, true)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.areItemStacksEqual((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new IEItemStackHandler(stack){
            final EnergyHelper.ItemEnergyStorage energyStorage;
            final CapabilityShader.ShaderWrapper_Item shaders;
            {
                super(stack2);
                this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:railgun", stack);
            }

            @Override
            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityEnergy.ENERGY || capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
            }

            @Override
            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityEnergy.ENERGY) {
                    return (T)this.energyStorage;
                }
                if (capability == CapabilityShader.SHADER_CAPABILITY) {
                    return (T)this.shaders;
                }
                return super.getCapability(capability, facing);
            }
        };
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.format((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName(stack);
    }

    public boolean isFull3D() {
        return true;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        super.onUpdate(stack, world, ent, slot, inHand);
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        int energy = Config.IEConfig.Tools.railgun_consumption;
        float energyMod = 1.0f + this.getUpgrades(stack).getFloat("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !ItemRailgun.findAmmo(player).isEmpty()) {
            player.setActiveHand(hand);
            player.world.playSound(null, player.posX, player.posY, player.posZ, this.getChargeTime(stack) <= 20 ? IESounds.chargeFast : IESounds.chargeSlow, SoundCategory.PLAYERS, 1.5f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        int inUse = this.getMaxItemUseDuration(stack) - count;
        if (inUse > this.getChargeTime(stack) && inUse % 20 == user.getRNG().nextInt(20)) {
            user.world.playSound(null, user.posX, user.posY, user.posZ, IESounds.spark, SoundCategory.PLAYERS, 0.8f + 0.2f * user.getRNG().nextFloat(), 0.5f + 0.5f * user.getRNG().nextFloat());
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        if (user instanceof EntityPlayer) {
            ItemStack ammo;
            int inUse = this.getMaxItemUseDuration(stack) - timeLeft;
            ItemNBTHelper.remove(stack, "inUse");
            if (inUse < this.getChargeTime(stack)) {
                return;
            }
            int energy = Config.IEConfig.Tools.railgun_consumption;
            float energyMod = 1.0f + this.getUpgrades(stack).getFloat("consumption");
            if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !(ammo = ItemRailgun.findAmmo((EntityPlayer)user)).isEmpty()) {
                Vec3d vec = user.getLookVec();
                float speed = 20.0f;
                EntityRailgunShot shot = new EntityRailgunShot(user.world, user, vec.x * (double)speed, vec.y * (double)speed, vec.z * (double)speed, Utils.copyStackWithAmount(ammo, 1));
                ammo.shrink(1);
                if (ammo.getCount() <= 0) {
                    ((EntityPlayer)user).inventory.deleteStack(ammo);
                }
                user.world.playSound(null, user.posX, user.posY, user.posZ, IESounds.railgunFire, SoundCategory.PLAYERS, 1.0f, 0.5f + 0.5f * user.getRNG().nextFloat());
                this.extractEnergy(stack, energy, false);
                if (!world.isRemote) {
                    user.world.spawnEntity((Entity)shot);
                }
            }
        }
    }

    public static ItemStack findAmmo(EntityPlayer player) {
        if (ItemRailgun.isAmmo(player.getHeldItem(EnumHand.OFF_HAND))) {
            return player.getHeldItem(EnumHand.OFF_HAND);
        }
        if (ItemRailgun.isAmmo(player.getHeldItem(EnumHand.MAIN_HAND))) {
            return player.getHeldItem(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            ItemStack itemstack = player.inventory.getStackInSlot(i);
            if (!ItemRailgun.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(stack);
        return prop != null;
    }

    public int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + this.getUpgrades(railgun).getFloat("speed")));
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 1600;
    }

    public String[] compileRender(ItemStack stack) {
        HashSet<String> render = new HashSet<String>();
        render.add("frame");
        render.add("barrel");
        render.add("grip");
        render.add("capacitors");
        render.add("sled");
        render.add("wires");
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if (upgrades.getDouble("speed") > 0.0) {
            render.add("upgrade_speed");
        }
        if (upgrades.getBoolean("scope")) {
            render.add("upgrade_scope");
        }
        return render.toArray(new String[render.size()]);
    }

    @Override
    public boolean canZoom(ItemStack stack, EntityPlayer player) {
        return this.getUpgrades(stack).getBoolean("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return this.zoomSteps;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.equals("upgrade_scope")) {
            return this.getUpgrades(stack).getBoolean("scope");
        }
        if (group.equals("upgrade_speed")) {
            return this.getUpgrades(stack).getDouble("speed") > 0.0;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective, EntityLivingBase entity) {
        return perspective;
    }
}

