/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPowerpack
extends ItemArmor
implements ISpecialArmor,
EnergyHelper.IIEEnergyItem {
    public ItemPowerpack() {
        super(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.CHEST);
        this.setMaxDamage(0);
        String name = "powerpack";
        this.setUnlocalizedName("immersiveengineering." + name);
        this.setCreativeTab(ImmersiveEngineering.creativeTab);
        IEContent.registeredIEItems.add((Item)this);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "immersiveengineering:textures/models/powerpack.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return ModelPowerpack.getModel();
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.format((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int energy = this.getEnergyStored(itemStack);
        if (energy > 0) {
            int pre = energy;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (!EnergyHelper.isFluxItem(player.getItemStackFromSlot(slot)) || player.getItemStackFromSlot(slot).getItem() instanceof ItemPowerpack) continue;
                energy -= EnergyHelper.insertFlux(player.getItemStackFromSlot(slot), Math.min(energy, 256), false);
            }
            if (pre != energy) {
                EnergyHelper.extractFlux(itemStack, pre - energy, false);
            }
        }
    }

    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 100000;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.isEmpty()) {
            return new ICapabilityProvider(){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == CapabilityEnergy.ENERGY ? this.energyStorage : null);
                }
            };
        }
        return super.initCapabilities(stack, nbt);
    }
}

