/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemIETool
extends ItemIEBase
implements ITool,
IEItemInterfaces.IGuiItem {
    static int hammerMaxDamage;
    static int cutterMaxDamage;

    public ItemIETool() {
        super("tool", 1, "hammer", "wirecutter", "voltmeter", "manual");
        hammerMaxDamage = Config.IEConfig.Tools.hammerDurabiliy;
        cutterMaxDamage = Config.IEConfig.Tools.cutterDurabiliy;
    }

    @Override
    public int getGuiID(ItemStack stack) {
        return stack.getItemDamage() == 3 ? 64 : -1;
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int[] link;
        if (ItemNBTHelper.hasKey(stack, "linkingPos") && (link = ItemNBTHelper.getIntArray(stack, "linkingPos")) != null && link.length > 3) {
            list.add(I18n.format((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
        if (stack.getItemDamage() == 0) {
            int i;
            String s;
            NBTTagList tagList;
            if (ItemNBTHelper.hasKey(stack, "multiblockPermission")) {
                tagList = stack.getTagCompound().getTagList("multiblockPermission", 8);
                s = I18n.format((String)"desc.immersiveengineering.info.multiblocksAllowed", (Object[])new Object[0]);
                if (!GuiScreen.isShiftKeyDown()) {
                    list.add(s + " " + I18n.format((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
                } else {
                    list.add(s);
                    for (i = 0; i < tagList.tagCount(); ++i) {
                        list.add(TextFormatting.DARK_GRAY + " " + I18n.format((String)("desc.immersiveengineering.info.multiblock." + tagList.getStringTagAt(i)), (Object[])new Object[0]));
                    }
                }
            }
            if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                tagList = stack.getTagCompound().getTagList("multiblockInterdiction", 8);
                s = I18n.format((String)"desc.immersiveengineering.info.multiblockForbidden", (Object[])new Object[0]);
                if (!GuiScreen.isShiftKeyDown()) {
                    list.add(s + " " + I18n.format((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
                } else {
                    list.add(s);
                    for (i = 0; i < tagList.tagCount(); ++i) {
                        list.add(TextFormatting.DARK_GRAY + " " + I18n.format((String)("desc.immersiveengineering.info.multiblock." + tagList.getStringTagAt(i)), (Object[])new Object[0]));
                    }
                }
            }
        }
        if (flag.isAdvanced() && stack.getItemDamage() < 2) {
            int nbtDamage = ItemNBTHelper.getInt(stack, stack.getItemDamage() == 0 ? "hammerDmg" : "cutterDmg");
            int maxDamage = stack.getItemDamage() == 0 ? hammerMaxDamage : cutterMaxDamage;
            list.add("Durability: " + (maxDamage - nbtDamage) + " / " + maxDamage);
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.getItemDamage() < 2;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int nbtDamage;
        if (stack.getItemDamage() == 0) {
            int nbtDamage2 = ItemNBTHelper.getInt(stack, "hammerDmg") + 1;
            if (nbtDamage2 < hammerMaxDamage) {
                ItemStack container = stack.copy();
                ItemNBTHelper.setInt(container, "hammerDmg", nbtDamage2);
                return container;
            }
        } else if (stack.getItemDamage() == 1 && (nbtDamage = ItemNBTHelper.getInt(stack, "cutterDmg") + 1) < cutterMaxDamage) {
            ItemStack container = stack.copy();
            ItemNBTHelper.setInt(container, "cutterDmg", nbtDamage);
            return container;
        }
        return ItemStack.EMPTY;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (stack.getMetadata() == 0) {
            int i;
            NBTTagList list;
            String[] permittedMultiblocks = null;
            String[] interdictedMultiblocks = null;
            if (ItemNBTHelper.hasKey(stack, "multiblockPermission")) {
                list = stack.getTagCompound().getTagList("multiblockPermission", 8);
                permittedMultiblocks = new String[list.tagCount()];
                for (i = 0; i < permittedMultiblocks.length; ++i) {
                    permittedMultiblocks[i] = list.getStringTagAt(i);
                }
            }
            if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                list = stack.getTagCompound().getTagList("multiblockInterdiction", 8);
                interdictedMultiblocks = new String[list.tagCount()];
                for (i = 0; i < interdictedMultiblocks.length; ++i) {
                    interdictedMultiblocks[i] = list.getStringTagAt(i);
                }
            }
            for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                boolean b;
                if (!mb.isBlockTrigger(world.getBlockState(pos))) continue;
                boolean bl = b = permittedMultiblocks == null;
                if (permittedMultiblocks != null) {
                    for (String s : permittedMultiblocks) {
                        if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                        b = true;
                    }
                }
                if (!b) break;
                if (interdictedMultiblocks != null) {
                    for (String s : interdictedMultiblocks) {
                        if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                        b = false;
                    }
                }
                if (!b) break;
                if (MultiblockHandler.postMultiblockFormationEvent(player, mb, pos, stack).isCanceled() || !mb.createStructure(world, pos, side, player)) continue;
                if (player instanceof EntityPlayerMP) {
                    IEAdvancements.TRIGGER_MULTIBLOCK.trigger((EntityPlayerMP)player, mb, stack);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        TileEntity tileEntity = world.getTileEntity(pos);
        if (stack.getItemDamage() == 0) {
            if (!(tileEntity instanceof IEBlockInterfaces.IDirectionalTile || tileEntity instanceof IEBlockInterfaces.IHammerInteraction || tileEntity instanceof IEBlockInterfaces.IConfigurableSides)) {
                return RotationUtil.rotateBlock(world, pos, side) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
        } else {
            if (stack.getItemDamage() == 1 && tileEntity instanceof IImmersiveConnectable) {
                TargetingInfo target = new TargetingInfo(side, hitX, hitY, hitZ);
                BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
                if (!((tileEntity = world.getTileEntity(masterPos)) instanceof IImmersiveConnectable)) {
                    return EnumActionResult.PASS;
                }
                if (!world.isRemote) {
                    IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                    boolean cut = ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(nodeHere), world, target);
                    IESaveData.setDirty(world.provider.getDimension());
                    if (cut) {
                        int nbtDamage = ItemNBTHelper.getInt(stack, "cutterDmg") + 1;
                        if (nbtDamage < cutterMaxDamage) {
                            ItemNBTHelper.setInt(stack, "cutterDmg", nbtDamage);
                        } else {
                            player.renderBrokenItemStack(stack);
                            player.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        }
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            if (stack.getItemDamage() == 2 && !world.isRemote) {
                if (!player.isSneaking() && (tileEntity instanceof IFluxReceiver || tileEntity instanceof IFluxProvider)) {
                    int max = 0;
                    int stored = 0;
                    if (tileEntity instanceof IFluxReceiver) {
                        max = ((IFluxReceiver)tileEntity).getMaxEnergyStored(side);
                        stored = ((IFluxReceiver)tileEntity).getEnergyStored(side);
                    } else {
                        max = ((IFluxProvider)tileEntity).getMaxEnergyStored(side);
                        stored = ((IFluxProvider)tileEntity).getEnergyStored(side);
                    }
                    if (max > 0) {
                        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.energyStorage", new Object[]{stored, max})});
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (player.isSneaking() && tileEntity instanceof IImmersiveConnectable) {
                    if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                        ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.provider.getDimension(), pos.getX(), pos.getY(), pos.getZ()});
                    } else {
                        int[] array = ItemNBTHelper.getIntArray(stack, "linkingPos");
                        BlockPos linkPos = new BlockPos(array[1], array[2], array[3]);
                        TileEntity tileEntityLinkingPos = world.getTileEntity(linkPos);
                        if (array[0] == world.provider.getDimension()) {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            if (nodeLink != null) {
                                Set<ImmersiveNetHandler.AbstractConnection> connections = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(nodeLink), world, true);
                                for (ImmersiveNetHandler.AbstractConnection con : connections) {
                                    if (!Utils.toCC(nodeHere).equals((Object)con.end)) continue;
                                    player.sendMessage((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.averageLoss", new Object[]{Utils.formatDouble(con.getAverageLossRate() * 100.0f, "###.000")}));
                                }
                            }
                        }
                        ItemNBTHelper.remove(stack, "linkingPos");
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean itemInteractionForEntity(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        return !player.world.isRemote && stack.getItemDamage() == 0 && RotationUtil.rotateEntity((Entity)entity, player);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return stack.getItemDamage() == 0;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (stack.getItemDamage() == 3) {
            if (world.isRemote) {
                CommonProxy.openGuiForItem(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.getItemDamage() == 0) {
            return ItemNBTHelper.getInt(stack, "hammerDmg") > 0;
        }
        if (stack.getItemDamage() == 1) {
            return ItemNBTHelper.getInt(stack, "cutterDmg") > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.getItemDamage() == 0) {
            return (double)ItemNBTHelper.getInt(stack, "hammerDmg") / (double)hammerMaxDamage;
        }
        if (stack.getItemDamage() == 1) {
            return (double)ItemNBTHelper.getInt(stack, "cutterDmg") / (double)cutterMaxDamage;
        }
        return 0.0;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.getItemDamage();
        return meta == 0 ? ImmutableSet.of((Object)"IE_HAMMER") : (meta == 1 ? ImmutableSet.of((Object)"IE_WIRECUTTER") : new HashSet());
    }

    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.getBlock().isToolEffective(type, state)) continue;
            return 6.0f;
        }
        return super.getStrVsBlock(stack, state);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return item.getItemDamage() != 3;
    }
}

