/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemIEShield
extends ItemUpgradeableTool
implements EnergyHelper.IIEEnergyItem,
IOBJModelCallback<ItemStack> {
    public ItemIEShield() {
        super("shield", 1, "SHIELD", new String[0]);
        this.setMaxDamage(1024);
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject((Object)this, (Object)ItemArmor.DISPENSER_BEHAVIOR);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new IEItemStackHandler(stack){
            final EnergyHelper.ItemEnergyStorage energyStorage;
            final CapabilityShader.ShaderWrapper_Item shaders;
            {
                super(stack2);
                this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:shield", stack);
            }

            @Override
            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityEnergy.ENERGY || capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
            }

            @Override
            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityEnergy.ENERGY) {
                    return (T)this.energyStorage;
                }
                if (capability == CapabilityShader.SHADER_CAPABILITY) {
                    return (T)this.shaders;
                }
                return super.getCapability(capability, facing);
            }
        };
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.areItemStacksEqual((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (this.getMaxEnergyStored(stack) > 0) {
            String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
            list.add(I18n.format((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        boolean blocking;
        super.onUpdate(stack, world, ent, slot, inHand);
        if (world.isRemote) {
            return;
        }
        if (ent instanceof EntityLivingBase) {
            inHand |= ((EntityLivingBase)ent).getHeldItem(EnumHand.OFF_HAND) == stack;
        }
        boolean bl = blocking = ent instanceof EntityLivingBase && ((EntityLivingBase)ent).isActiveItemStackBlocking();
        if (!inHand || !blocking) {
            int cooldown;
            if (this.getUpgrades(stack).hasKey("flash_cooldown") && this.extractEnergy(stack, 20, true) == 20) {
                this.extractEnergy(stack, 20, false);
                cooldown = this.getUpgrades(stack).getInteger("flash_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).removeTag("flash_cooldown");
                } else {
                    this.getUpgrades(stack).setInteger("flash_cooldown", cooldown);
                }
            }
            if (this.getUpgrades(stack).hasKey("shock_cooldown") && this.extractEnergy(stack, 20, true) == 20) {
                this.extractEnergy(stack, 20, false);
                cooldown = this.getUpgrades(stack).getInteger("shock_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).removeTag("shock_cooldown");
                } else {
                    this.getUpgrades(stack).setInteger("shock_cooldown", cooldown);
                }
            }
        }
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    public void hitShield(ItemStack stack, EntityPlayer player, DamageSource source, float amount, LivingAttackEvent event) {
        if (this.getUpgrades(stack).getBoolean("flash") && this.getUpgrades(stack).getInteger("flash_cooldown") <= 0) {
            Vec3d look = player.getLookVec();
            List<EntityLivingBase> targets = Utils.getTargetsInCone(player.getEntityWorld(), player.getPositionVector().subtract(look), player.getLookVec().scale(9.0), 1.57079f, 0.5f);
            for (EntityLivingBase t : targets) {
                if (player.equals((Object)t)) continue;
                t.addPotionEffect(new PotionEffect(IEPotions.flashed, 100, 1));
                if (!(t instanceof EntityLiving)) continue;
                ((EntityLiving)t).setAttackTarget(null);
            }
            this.getUpgrades(stack).setInteger("flash_cooldown", 40);
        }
        if (this.getUpgrades(stack).getBoolean("shock") && this.getUpgrades(stack).getInteger("shock_cooldown") <= 0) {
            boolean b = false;
            if (event.getSource().isProjectile() && event.getSource().getImmediateSource() != null) {
                Entity projectile = event.getSource().getImmediateSource();
                projectile.setDead();
                event.setCanceled(true);
                b = true;
            }
            if (event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityLivingBase && event.getSource().getTrueSource().getDistanceSqToEntity((Entity)player) < 4.0) {
                IEDamageSources.TeslaDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(1.0f, true);
                dmgsrc.apply(event.getSource().getTrueSource());
                b = true;
            }
            if (b) {
                this.getUpgrades(stack).setInteger("shock_cooldown", 40);
                player.world.playSound(null, player.posX, player.posY, player.posZ, IESounds.spark, SoundCategory.BLOCKS, 2.5f, 0.5f + Utils.RAND.nextFloat());
            }
        }
    }

    public boolean getIsRepairable(ItemStack stack, ItemStack material) {
        return Utils.compareToOreName(material, "ingotSteel");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getUpgrades(container).getBoolean("flash") || this.getUpgrades(container).getBoolean("shock") ? 1600 : 0;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        playerIn.setActiveHand(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public boolean shouldRenderGroup(ItemStack object, String group) {
        if ("flash".equals(group)) {
            return this.getUpgrades(object).getBoolean("flash");
        }
        if ("shock".equals(group)) {
            return this.getUpgrades(object).getBoolean("shock");
        }
        return true;
    }

    @Override
    public Matrix4 handlePerspective(ItemStack Object2, ItemCameraTransforms.TransformType cameraTransformType, Matrix4 perspective, EntityLivingBase entity) {
        if (entity != null && entity.isHandActive()) {
            if (entity.getActiveHand() == EnumHand.MAIN_HAND == (entity.getPrimaryHand() == EnumHandSide.RIGHT)) {
                if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                    perspective.rotate(-0.15, 1.0, 0.0, 0.0).translate(-0.25, 0.5, -0.4375);
                } else if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                    perspective.rotate(0.52359, 1.0, 0.0, 0.0).rotate(0.78539, 0.0, 1.0, 0.0).translate(0.40625, -0.125, -0.125);
                }
            } else if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                perspective.rotate(0.15, 1.0, 0.0, 0.0).translate(0.25, 0.375, 0.4375);
            } else if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                perspective.rotate(-0.52359, 1.0, 0.0, 0.0).rotate(0.78539, 0.0, 1.0, 0.0).translate(0.1875, 0.3125, 0.5625);
            }
        }
        return perspective;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "SHIELD", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "SHIELD", stack, true)};
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 2;
    }
}

