/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.ItemIEBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemIESeed
extends ItemIEBase
implements IPlantable {
    private Block cropBlock;

    public ItemIESeed(Block cropBlock, String ... subNames) {
        super("seed", 64, subNames);
        this.cropBlock = cropBlock;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        if (side != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        if (player.canPlayerEdit(pos, side, stack) && player.canPlayerEdit(pos.add(0, 1, 0), side, stack)) {
            IBlockState state = world.getBlockState(pos);
            if (state.getBlock().canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this) && world.isAirBlock(pos.add(0, 1, 0))) {
                world.setBlockState(pos.add(0, 1, 0), this.cropBlock.getDefaultState());
                stack.shrink(1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return ((IPlantable)this.cropBlock).getPlantType(world, pos);
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.cropBlock.getDefaultState();
    }
}

