/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrillhead
extends ItemIEBase
implements IDrillHead {
    public DrillHeadPerm[] perms;

    public ItemDrillhead() {
        super("drillhead", 1, "steel", "iron");
        this.perms = new DrillHeadPerm[this.subNames.length];
        this.addPerm(0, new DrillHeadPerm("ingotSteel", 3, 1, 3, 10.0f, 7, 10000, "immersiveengineering:items/drill_diesel"));
        this.addPerm(1, new DrillHeadPerm("ingotIron", 2, 1, 2, 9.0f, 6, 6000, "immersiveengineering:items/drill_iron"));
    }

    private void addPerm(int i, DrillHeadPerm perm) {
        if (i < this.perms.length) {
            this.perms[i] = perm;
        }
    }

    private DrillHeadPerm getHeadPerm(ItemStack stack) {
        if (stack.getItemDamage() >= 0 && stack.getItemDamage() < this.perms.length) {
            return this.perms[stack.getItemDamage()];
        }
        return new DrillHeadPerm("", 0, 0, 0, 0.0f, 0, 0, "immersiveengineering:items/drill_diesel");
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (stack.getItemDamage() < this.getSubNames().length) {
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.drillhead.size", (Object[])new Object[]{this.getHeadPerm((ItemStack)stack).drillSize, this.getHeadPerm((ItemStack)stack).drillDepth}));
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.drillhead.level", (Object[])new Object[]{Utils.getHarvestLevelName(this.getMiningLevel(stack))}));
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.drillhead.speed", (Object[])new Object[]{Utils.formatDouble(this.getMiningSpeed(stack), "0.###")}));
            list.add(I18n.format((String)"desc.immersiveengineering.flavour.drillhead.damage", (Object[])new Object[]{Utils.formatDouble(this.getAttackDamage(stack), "0.###")}));
            int maxDmg = this.getMaximumHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            String status = "" + ((double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN)));
            String s = status + (this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack)) + "/" + this.getMaximumHeadDamage(stack);
            list.add(I18n.format((String)"desc.immersiveengineering.info.durability", (Object[])new Object[]{s}));
        }
    }

    @Override
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.isInCreativeTab(tab)) {
            for (int i = 0; i < this.getSubNames().length; ++i) {
                ItemStack s = new ItemStack((Item)this, 1, i);
                if (!ApiUtils.isExistingOreName(this.getHeadPerm((ItemStack)s).repairMaterial)) continue;
                list.add((Object)s);
            }
        }
    }

    public boolean getIsRepairable(ItemStack stack, ItemStack material) {
        return Utils.compareToOreName(material, this.getHeadPerm((ItemStack)stack).repairMaterial);
    }

    @Override
    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, EntityPlayer player) {
        return false;
    }

    @Override
    public void afterBlockbreak(ItemStack drill, ItemStack head, EntityPlayer player) {
    }

    @Override
    public int getMiningLevel(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillLevel;
    }

    @Override
    public float getMiningSpeed(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillSpeed;
    }

    @Override
    public float getAttackDamage(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillAttack;
    }

    @Override
    public int getHeadDamage(ItemStack head) {
        return ItemNBTHelper.getInt(head, "headDamage");
    }

    @Override
    public int getMaximumHeadDamage(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).maxDamage;
    }

    @Override
    public void damageHead(ItemStack head, int dmg) {
        ItemNBTHelper.setInt(head, "headDamage", ItemNBTHelper.getInt(head, "headDamage") + dmg);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getDrillTexture(ItemStack drill, ItemStack head) {
        return this.getHeadPerm((ItemStack)head).sprite;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemNBTHelper.getInt(stack, "headDamage") / (double)this.getMaximumHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, "headDamage") > 0;
    }

    @Override
    public ImmutableList<BlockPos> getExtraBlocksDug(ItemStack head, World world, EntityPlayer player, RayTraceResult mop) {
        EnumFacing side = mop.sideHit;
        int diameter = this.getHeadPerm((ItemStack)head).drillSize;
        int depth = this.getHeadPerm((ItemStack)head).drillDepth;
        BlockPos startPos = mop.getBlockPos();
        IBlockState state = world.getBlockState(startPos);
        Block block = state.getBlock();
        float maxHardness = 1.0f;
        if (block != null && !block.isAir(state, (IBlockAccess)world, startPos)) {
            maxHardness = state.getPlayerRelativeBlockHardness(player, world, startPos) * 0.6f;
        }
        if (maxHardness < 0.0f) {
            maxHardness = 0.0f;
        }
        if (diameter % 2 == 0) {
            float hx = (float)mop.hitVec.x - (float)mop.getBlockPos().getX();
            float hy = (float)mop.hitVec.y - (float)mop.getBlockPos().getY();
            float hz = (float)mop.hitVec.z - (float)mop.getBlockPos().getZ();
            if (side.getAxis() == EnumFacing.Axis.Y && (double)hx < 0.5 || side.getAxis() == EnumFacing.Axis.Z && (double)hx < 0.5) {
                startPos = startPos.add(-diameter / 2, 0, 0);
            }
            if (side.getAxis() != EnumFacing.Axis.Y && (double)hy < 0.5) {
                startPos = startPos.add(0, -diameter / 2, 0);
            }
            if (side.getAxis() == EnumFacing.Axis.Y && (double)hz < 0.5 || side.getAxis() == EnumFacing.Axis.X && (double)hz < 0.5) {
                startPos = startPos.add(0, 0, -diameter / 2);
            }
        } else {
            startPos = startPos.add(-(side.getAxis() == EnumFacing.Axis.X ? 0 : diameter / 2), -(side.getAxis() == EnumFacing.Axis.Y ? 0 : diameter / 2), -(side.getAxis() == EnumFacing.Axis.Z ? 0 : diameter / 2));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    boolean hardness;
                    BlockPos pos = startPos.add(side.getAxis() == EnumFacing.Axis.X ? dd : dw, side.getAxis() == EnumFacing.Axis.Y ? dd : dh, side.getAxis() == EnumFacing.Axis.Y ? dh : (side.getAxis() == EnumFacing.Axis.X ? dw : dd));
                    if (pos.equals((Object)mop.getBlockPos())) continue;
                    state = world.getBlockState(pos);
                    block = state.getBlock();
                    float h = state.getPlayerRelativeBlockHardness(player, world, pos);
                    boolean canHarvest = block.canHarvestBlock((IBlockAccess)world, pos, player);
                    boolean drillMat = ((ItemDrill)IEContent.itemDrill).isEffective(state.getMaterial());
                    boolean bl = hardness = h > maxHardness;
                    if (!canHarvest || !drillMat || !hardness) continue;
                    b.add((Object)pos);
                }
            }
        }
        return b.build();
    }

    public static class DrillHeadPerm {
        final String repairMaterial;
        final int drillSize;
        final int drillDepth;
        final int drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        public final String texture;
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite sprite;

        public DrillHeadPerm(String repairMaterial, int drillSize, int drillDepth, int drillLevel, float drillSpeed, int drillAttack, int maxDamage, String texture) {
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
        }
    }
}

