/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCoresample
extends ItemIEBase {
    public ItemCoresample() {
        super("coresample", 1, new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (ItemNBTHelper.hasKey(stack, "coords")) {
            String s2;
            WorldClient clientWorld;
            if (ItemNBTHelper.hasKey(stack, "mineral")) {
                String mineral = ItemNBTHelper.getString(stack, "mineral");
                String unloc = "desc.immersiveengineering.info.mineral." + mineral;
                String loc = I18n.format((String)unloc, (Object[])new Object[0]);
                list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.mineral", (Object[])new Object[]{unloc.equals(loc) ? mineral : loc}));
            } else {
                list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.noMineral", (Object[])new Object[0]));
            }
            int[] coords = ItemNBTHelper.getIntArray(stack, "coords");
            boolean singleplayer = Minecraft.getMinecraft().isSingleplayer();
            if ((world == null || world.provider.getDimension() != 0) && (clientWorld = Minecraft.getMinecraft().world) != null && clientWorld.provider.getDimension() == coords[0]) {
                world = clientWorld;
            }
            String s0 = coords[1] * 16 + ", " + coords[2] * 16;
            String s1 = coords[1] * 16 + 16 + ", " + (coords[2] * 16 + 16);
            if (world != null && world.provider != null) {
                String name = world.provider.getDimensionType().getName();
                if (name.toLowerCase(Locale.ENGLISH).startsWith("the ")) {
                    name = name.substring(4);
                }
                s2 = name;
            } else {
                s2 = "Dimension " + coords[0];
            }
            list.add(s2);
            list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.pos", (Object[])new Object[]{s0, s1, ""}));
            if (ItemNBTHelper.hasKey(stack, "infinite")) {
                list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.infinite", (Object[])new Object[0]));
            } else if (ItemNBTHelper.hasKey(stack, "depletion")) {
                list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.yield", (Object[])new Object[]{ExcavatorHandler.mineralVeinCapacity - ItemNBTHelper.getInt(stack, "depletion")}));
            }
            boolean hasStamp = ItemNBTHelper.hasKey(stack, "timestamp");
            if (hasStamp && world != null) {
                long timestamp = ItemNBTHelper.getLong(stack, "timestamp");
                long dist = world.getTotalWorldTime() - timestamp;
                if (dist < 0L) {
                    list.add("Somehow this sample is dated in the future...are you a time traveller?!");
                } else {
                    list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.timestamp", (Object[])new Object[]{ClientUtils.fomatTimestamp(dist, ClientUtils.TimestampFormat.DHM)}));
                }
            } else if (hasStamp) {
                list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.timezone", (Object[])new Object[0]));
            } else {
                list.add(I18n.format((String)"chat.immersiveengineering.info.coresample.noTimestamp", (Object[])new Object[0]));
            }
        }
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        if (player.isSneaking()) {
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (!block.isReplaceable((IBlockAccess)world, pos)) {
                pos = pos.offset(side);
            }
            if (!stack.isEmpty() && player.canPlayerEdit(pos, side, stack) && world.mayPlace((Block)IEContent.blockStoneDevice, pos, false, side, null)) {
                IBlockState toolbox = IEContent.blockStoneDevice.getStateFromMeta(BlockTypes_StoneDevices.CORESAMPLE.getMeta());
                if (world.setBlockState(pos, toolbox, 3)) {
                    IEContent.blockStoneDevice.onIEBlockPlacedBy(world, pos, toolbox, side, hitX, hitY, hitZ, (EntityLivingBase)player, stack);
                    SoundType soundtype = world.getBlockState(pos).getBlock().getSoundType(world.getBlockState(pos), world, pos, (Entity)player);
                    world.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    stack.shrink(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return super.onItemUse(player, world, pos, hand, side, hitX, hitY, hitZ);
    }
}

