/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemChemthrower
extends ItemUpgradeableTool
implements IEItemInterfaces.IAdvancedFluidItem,
IOBJModelCallback<ItemStack>,
ITool {
    public ItemChemthrower() {
        super("chemthrower", 1, "CHEMTHROWER", new String[0]);
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int cap = this.getCapacity(stack, 2000);
        if (!this.getUpgrades(stack).getBoolean("multitank")) {
            list.add(this.formatFluidStack(this.getFluid(stack), cap));
        } else {
            for (int i = 0; i < 3; ++i) {
                list.add((i > 0 ? "  " : "") + this.formatFluidStack(ItemNBTHelper.getFluidStack(stack, "Fluid" + (i > 0 ? Integer.valueOf(i) : "")), cap));
            }
        }
    }

    private String formatFluidStack(FluidStack fs, int capacity) {
        if (fs != null) {
            TextFormatting rarity = fs.getFluid().getRarity() == EnumRarity.COMMON ? TextFormatting.GRAY : fs.getFluid().getRarity().rarityColor;
            return rarity + fs.getLocalizedName() + TextFormatting.GRAY + ": " + fs.amount + "/" + capacity + "mB";
        }
        return I18n.format((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0]);
    }

    public boolean isFull3D() {
        return true;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (player.isSneaking()) {
            if (!world.isRemote) {
                ItemNBTHelper.setBoolean(stack, "ignite", !ItemNBTHelper.getBoolean(stack, "ignite"));
            }
        } else {
            player.setActiveHand(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getFluid() != null) {
            int consumed = Config.IEConfig.Tools.chemthrower_consumption;
            int duration = this.getMaxItemUseDuration(stack) - count;
            if (consumed * duration <= fs.amount) {
                float range;
                Vec3d v = player.getLookVec();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas(fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).getBoolean("focus")) {
                    range += 0.25f;
                    scatter -= 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ItemNBTHelper.getBoolean(stack, "ignite");
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.addVector(player.getRNG().nextGaussian() * (double)scatter, player.getRNG().nextGaussian() * (double)scatter, player.getRNG().nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(player.world, player, vecDir.x * 0.25, vecDir.y * 0.25, vecDir.z * 0.25, fs);
                    chem.motionX = vecDir.x * (double)range;
                    chem.motionY = vecDir.y * (double)range;
                    chem.motionZ = vecDir.z * (double)range;
                    if (ignite) {
                        chem.setFire(10);
                    }
                    if (player.world.isRemote) continue;
                    player.world.spawnEntity((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        player.world.playSound(null, player.posX, player.posY, player.posZ, IESounds.sprayFire, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    } else {
                        player.world.playSound(null, player.posX, player.posY, player.posZ, IESounds.spray, SoundCategory.PLAYERS, 0.5f, 0.75f);
                    }
                }
            } else {
                player.stopActiveHand();
            }
        } else {
            player.stopActiveHand();
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            int duration = this.getMaxItemUseDuration(stack) - timeLeft;
            fs.amount -= Config.IEConfig.Tools.chemthrower_consumption * duration;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(stack, "Fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
            }
        }
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public void switchTank(ItemStack stack, boolean forward) {
        if (this.getUpgrades(stack).getBoolean("multitank")) {
            NBTTagCompound fluidTag = ItemNBTHelper.getTagCompound(stack, "Fluid");
            NBTTagCompound fluidTag1 = ItemNBTHelper.getTagCompound(stack, "Fluid1");
            NBTTagCompound fluidTag2 = ItemNBTHelper.getTagCompound(stack, "Fluid2");
            if (forward) {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag1);
            } else {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag1);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag);
            }
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack, 2000)) {
            fs.amount = this.getCapacity(stack, 2000);
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if ("base".equals(group) || "grip".equals(group) || "cage".equals(group) || "tanks".equals(group)) {
            return true;
        }
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if ("large_tank".equals(group) && upgrades.getInteger("capacity") > 0) {
            return true;
        }
        if ("multi_tank".equals(group) && upgrades.getBoolean("multitank")) {
            return true;
        }
        return "tank".equals(group);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.areItemStacksEqual((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new IEItemStackHandler(stack){
            IEItemFluidHandler fluids;
            CapabilityShader.ShaderWrapper_Item shaders;
            {
                super(stack2);
                this.fluids = new IEItemFluidHandler(stack, 2000);
                this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:chemthrower", stack);
            }

            @Override
            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
            }

            @Override
            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                    return (T)((Object)this.fluids);
                }
                if (capability == CapabilityShader.SHADER_CAPABILITY) {
                    return (T)this.shaders;
                }
                return super.getCapability(capability, facing);
            }
        };
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 4;
    }

    @Override
    public int getCapacity(ItemStack stack, int baseCapacity) {
        return baseCapacity + this.getUpgrades(stack).getInteger("capacity");
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 32, "CHEMTHROWER", stack, true)};
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

