/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotFlare;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotHoming;
import blusunrize.immersiveengineering.common.entities.EntityWolfpackShot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBullet
extends ItemIEBase
implements IEItemInterfaces.ITextureOverride {
    public ItemBullet() {
        super("bullet", 64, "empty_casing", "empty_shell", "bullet");
        BulletHandler.emptyCasing = new ItemStack((Item)this, 1, 0);
        BulletHandler.emptyShell = new ItemStack((Item)this, 1, 1);
        BulletHandler.basicCartridge = new ItemStack((Item)this, 1, 2);
    }

    public static void initBullets() {
        BulletHandler.registerBullet("casull", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeCasullDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Casull, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_casull")));
        BulletHandler.registerBullet("armor_piercing", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causePiercingDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_AP, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_armor_piercing")));
        BulletHandler.registerBullet("buckshot", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeBuckshotDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Buck, true, false, BulletHandler.emptyShell, new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_buckshot")}){

            @Override
            public int getProjectileCount(EntityPlayer shooter) {
                return 10;
            }
        });
        BulletHandler.registerBullet("he", new BulletHandler.DamagingBullet(null, 0.0f, BulletHandler.emptyCasing, new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_he")}){

            @Override
            public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
                world.createExplosion((Entity)shooter, projectile.posX, projectile.posY, projectile.posZ, 2.0f, false);
            }

            @Override
            public Entity getProjectile(@Nullable EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean charged) {
                if (projectile instanceof EntityRevolvershot) {
                    ((EntityRevolvershot)projectile).setGravity(0.05f);
                    ((EntityRevolvershot)projectile).setMovementDecay(0.9f);
                }
                return projectile;
            }

            @Override
            public SoundEvent getSound() {
                return IESounds.revolverFireThump;
            }
        });
        BulletHandler.registerBullet("silver", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeSilverDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Silver, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_silver")));
        BulletHandler.registerBullet("dragonsbreath", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeDragonsbreathDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Dragon, true, true, BulletHandler.emptyShell, new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_dragonsbreath")}){

            @Override
            public int getProjectileCount(EntityPlayer shooter) {
                return 30;
            }

            @Override
            public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
                ((EntityRevolvershot)projectile).setTickLimit(10);
                projectile.setFire(3);
                return projectile;
            }
        });
        BulletHandler.registerBullet("potion", new PotionBullet());
        BulletHandler.registerBullet("flare", new FlareBullet());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.isInCreativeTab(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 1));
            for (Map.Entry<String, BulletHandler.IBullet> entry : BulletHandler.registry.entrySet()) {
                if (!entry.getValue().isProperCartridge()) continue;
                ItemStack s = new ItemStack((Item)this, 1, 2);
                ItemNBTHelper.setString(s, "bullet", entry.getKey());
                list.add((Object)s);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String key;
        BulletHandler.IBullet bullet;
        if (stack.getItemDamage() == 2 && (bullet = BulletHandler.getBullet(key = ItemNBTHelper.getString(stack, "bullet"))) != null) {
            bullet.addTooltip(stack, world, list, flag);
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        if (stack.getItemDamage() == 2) {
            String s = "item.immersiveengineering.bullet.";
            String key = ItemNBTHelper.getString(stack, "bullet");
            key = BulletHandler.handleLeagcyNames(key);
            s = s + key;
            BulletHandler.IBullet bullet = BulletHandler.getBullet(key);
            if (bullet != null) {
                s = bullet.getUnlocalizedName(stack, s);
            }
            return I18n.translateToLocal((String)(s + ".name")).trim();
        }
        return super.getItemStackDisplayName(stack);
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        BulletHandler.IBullet bullet;
        if (stack.getMetadata() == 2 && ItemNBTHelper.hasKey(stack, "bullet") && (bullet = BulletHandler.getBullet(ItemNBTHelper.getString(stack, "bullet"))) != null) {
            return bullet.getColour(stack, pass);
        }
        return super.getColourForIEItem(stack, pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getModelCacheKey(ItemStack stack) {
        if (stack.getMetadata() == 2 && ItemNBTHelper.hasKey(stack, "bullet")) {
            return ItemNBTHelper.getString(stack, "bullet");
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        BulletHandler.IBullet bullet = BulletHandler.getBullet(key);
        if (bullet != null) {
            return Arrays.asList(bullet.getTextures());
        }
        return Arrays.asList(new ResourceLocation("immersiveengieering:items/bullet_casull"));
    }

    public static class WolfpackPartBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackPartBullet() {
            super((Entity[] entities) -> IEDamageSources.causeWolfpackDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_WolfpackPart, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_wolfpack"));
        }

        @Override
        public boolean isProperCartridge() {
            return false;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class WolfpackBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackBullet() {
            super((Entity[] entities) -> IEDamageSources.causeWolfpackDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Wolfpack, BulletHandler.emptyShell, new ResourceLocation("immersiveengineering:items/bullet_wolfpack"));
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            Vec3d v = new Vec3d(-projectile.motionX, -projectile.motionY, -projectile.motionZ);
            int split = 6;
            for (int i = 0; i < split; ++i) {
                EntityWolfpackShot bullet;
                float angle = (float)i * (360.0f / (float)split);
                Matrix4 matrix = new Matrix4();
                matrix.rotate(angle, v.x, v.y, v.z);
                Vec3d vecDir = new Vec3d(0.0, 1.0, 0.0);
                vecDir = matrix.apply(vecDir);
                EntityWolfpackShot entityWolfpackShot = bullet = shooter != null ? new EntityWolfpackShot(world, shooter, vecDir.x * 1.5, vecDir.y * 1.5, vecDir.z * 1.5, this, null) : new EntityWolfpackShot(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this);
                if (target.entityHit instanceof EntityLivingBase) {
                    bullet.targetOverride = (EntityLivingBase)target.entityHit;
                }
                bullet.setPosition(target.hitVec.x + vecDir.x, target.hitVec.y + vecDir.y, target.hitVec.z + vecDir.z);
                bullet.motionX = vecDir.x * 0.375;
                bullet.motionY = vecDir.y * 0.375;
                bullet.motionZ = vecDir.z * 0.375;
                world.spawnEntity((Entity)bullet);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class HomingBullet
    extends BulletHandler.DamagingBullet {
        public HomingBullet(float damage, ResourceLocation ... textures) {
            super(new Function<Entity[], DamageSource>(){

                @Override
                public DamageSource apply(Entity[] entities) {
                    return IEDamageSources.causeHomingDamage((EntityRevolvershot)entities[0], entities[1]);
                }
            }, damage, BulletHandler.emptyCasing, textures);
        }

        @Override
        public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            EntityRevolvershotHoming shot = shooter != null ? new EntityRevolvershotHoming(projectile.world, (EntityLivingBase)shooter, projectile.motionX * 1.5, projectile.motionY * 1.5, projectile.motionZ * 1.5, this, cartridge) : new EntityRevolvershotHoming(projectile.world, projectile.posX, projectile.posY, projectile.posZ, 0.0, 0.0, 0.0, this);
            shot.motionX = projectile.motionX;
            shot.motionY = projectile.motionY;
            shot.motionZ = projectile.motionZ;
            shot.bulletElectro = electro;
            return shot;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class FlareBullet
    implements BulletHandler.IBullet {
        static ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_flare"), new ResourceLocation("immersiveengineering:items/bullet_flare_layer")};

        @Override
        public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            EntityRevolvershotFlare flare = shooter != null ? new EntityRevolvershotFlare(projectile.world, (EntityLivingBase)shooter, projectile.motionX * 1.5, projectile.motionY * 1.5, projectile.motionZ * 1.5, this, cartridge) : new EntityRevolvershotFlare(projectile.world, projectile.posX, projectile.posY, projectile.posZ, 0.0, 0.0, 0.0, this);
            flare.motionX = projectile.motionX;
            flare.motionY = projectile.motionY;
            flare.motionZ = projectile.motionZ;
            flare.bulletElectro = electro;
            flare.colour = this.getColour(cartridge, 1);
            flare.setColourSynced();
            return flare;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return BulletHandler.emptyShell;
        }

        @Override
        public ResourceLocation[] getTextures() {
            return textures;
        }

        @Override
        public void addTooltip(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
            if (stack.getItem() instanceof IEItemInterfaces.IColouredItem) {
                String hexCol = Integer.toHexString(((IEItemInterfaces.IColouredItem)stack.getItem()).getColourForIEItem(stack, 1));
                list.add(I18n.translateToLocalFormatted((String)"desc.immersiveengineering.info.bullet.flareColour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer != 1) {
                return -1;
            }
            return ItemNBTHelper.hasKey(stack, "flareColour") ? ItemNBTHelper.getInt(stack, "flareColour") : 13381126;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static class PotionBullet
    extends BulletHandler.DamagingBullet {
        public PotionBullet() {
            super((Entity[] entities) -> IEDamageSources.causePotionDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Potion, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_potion"), new ResourceLocation("immersiveengineering:items/bullet_potion_layer"));
        }

        @Override
        public String getUnlocalizedName(ItemStack cartridge, String baseName) {
            ItemStack pot = ItemNBTHelper.getItemStack(cartridge, "potion");
            if (!pot.isEmpty()) {
                if (pot.getItem() instanceof ItemLingeringPotion) {
                    baseName = baseName + ".linger";
                } else if (pot.getItem() instanceof ItemSplashPotion) {
                    baseName = baseName + ".splash";
                }
            }
            return baseName;
        }

        @Override
        public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            ((EntityRevolvershot)projectile).bulletPotion = ItemNBTHelper.getItemStack(cartridge, "potion");
            return projectile;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            EntityRevolvershot bullet = (EntityRevolvershot)projectile;
            if (!bullet.bulletPotion.isEmpty() && bullet.bulletPotion.hasTagCompound()) {
                PotionType potionType = PotionUtils.getPotionFromItem((ItemStack)bullet.bulletPotion);
                List effects = PotionUtils.getEffectsFromStack((ItemStack)bullet.bulletPotion);
                if (effects != null) {
                    if (bullet.bulletPotion.getItem() instanceof ItemLingeringPotion) {
                        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(bullet.world, bullet.posX, bullet.posY, bullet.posZ);
                        entityareaeffectcloud.setOwner(shooter);
                        entityareaeffectcloud.setRadius(3.0f);
                        entityareaeffectcloud.setRadiusOnUse(-0.5f);
                        entityareaeffectcloud.setWaitTime(10);
                        entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
                        entityareaeffectcloud.setPotion(potionType);
                        for (PotionEffect potioneffect : effects) {
                            entityareaeffectcloud.addEffect(new PotionEffect(potioneffect.getPotion(), potioneffect.getDuration(), potioneffect.getAmplifier()));
                        }
                        bullet.world.spawnEntity((Entity)entityareaeffectcloud);
                    } else if (bullet.bulletPotion.getItem() instanceof ItemSplashPotion) {
                        List livingEntities = bullet.world.getEntitiesWithinAABB(EntityLivingBase.class, bullet.getEntityBoundingBox().grow(4.0, 2.0, 4.0));
                        if (livingEntities != null && !livingEntities.isEmpty()) {
                            for (EntityLivingBase living : livingEntities) {
                                double dist;
                                if (!living.canBeHitWithPotion() || !((dist = bullet.getDistanceSqToEntity((Entity)living)) < 16.0)) continue;
                                double dist2 = 1.0 - Math.sqrt(dist) / 4.0;
                                if (living == target.entityHit) {
                                    dist2 = 1.0;
                                }
                                for (PotionEffect p : effects) {
                                    if (p.getPotion().isInstant()) {
                                        p.getPotion().affectEntity((Entity)bullet, (Entity)shooter, living, p.getAmplifier(), dist2);
                                        continue;
                                    }
                                    int j = (int)(dist2 * (double)p.getDuration() + 0.5);
                                    if (j <= 20) continue;
                                    living.addPotionEffect(new PotionEffect(p.getPotion(), j, p.getAmplifier()));
                                }
                            }
                        }
                    } else if (target.entityHit instanceof EntityLivingBase) {
                        for (PotionEffect p : effects) {
                            if (p.getDuration() < 1) {
                                p = new PotionEffect(p.getPotion(), 1);
                            }
                            ((EntityLivingBase)target.entityHit).addPotionEffect(p);
                        }
                    }
                }
                world.playEvent(2002, new BlockPos((Entity)bullet), PotionUtils.getPotionColor((PotionType)potionType));
            }
        }

        @Override
        public void addTooltip(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (!pot.isEmpty() && pot.getItem() instanceof ItemPotion) {
                PotionUtils.addPotionTooltip((ItemStack)pot, list, (float)1.0f);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer == 1) {
                ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
                return pot.isEmpty() ? -13083194 : PotionUtils.getPotionColorFromEffectList((Collection)PotionUtils.getEffectsFromStack((ItemStack)pot));
            }
            return -1;
        }
    }
}

