/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryTile
implements IInventory {
    TileEntity tile;
    IIEInventory inv;
    String name;

    public InventoryTile(TileEntity tile) {
        this.tile = tile;
        this.inv = (IIEInventory)tile;
        this.name = tile.getClass().getName();
        this.name = "IE" + this.name.substring(this.name.lastIndexOf("TileEntity") + "TileEntity".length());
    }

    public String getName() {
        return this.name;
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return new TextComponentString(this.name);
    }

    public int getSizeInventory() {
        return this.inv.getInventory().size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inv.getInventory()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.inv.getInventory().get(index);
    }

    public ItemStack decrStackSize(int index, int count) {
        ItemStack stack = (ItemStack)this.inv.getInventory().get(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() <= count) {
                this.inv.getInventory().set(index, (Object)ItemStack.EMPTY);
            } else if ((stack = stack.splitStack(count)).getCount() == 0) {
                this.inv.getInventory().set(index, (Object)ItemStack.EMPTY);
            }
        }
        return stack;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack ret = ((ItemStack)this.inv.getInventory().get(index)).copy();
        this.inv.getInventory().set(index, (Object)ItemStack.EMPTY);
        return ret;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inv.getInventory().set(index, (Object)stack);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        this.tile.markDirty();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return !this.tile.isInvalid() && this.tile.getDistanceSq(player.posX, player.posY, player.posZ) < 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.inv.doGraphicalUpdates(i);
        }
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return this.inv.isStackValid(index, stack);
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.inv.getInventory().size(); ++i) {
            this.inv.getInventory().set(i, (Object)ItemStack.EMPTY);
        }
    }
}

