/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryShader
implements IInventory {
    private CapabilityShader.ShaderWrapper wrapper;
    private Container container;
    @Nonnull
    public ItemStack shader;
    private String name;

    public InventoryShader(Container par1Container, CapabilityShader.ShaderWrapper wrapper) {
        this.container = par1Container;
        this.wrapper = wrapper;
        this.shader = wrapper.getShaderItem();
        this.name = wrapper.getShaderType();
    }

    public int getSizeInventory() {
        return 1;
    }

    public boolean isEmpty() {
        return this.shader.isEmpty();
    }

    public ItemStack getStackInSlot(int i) {
        return this.shader;
    }

    public ItemStack removeStackFromSlot(int i) {
        if (!this.shader.isEmpty()) {
            ItemStack itemstack = this.shader.copy();
            this.shader = ItemStack.EMPTY;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack decrStackSize(int i, int j) {
        if (!this.shader.isEmpty()) {
            if (this.shader.getCount() <= j) {
                ItemStack itemstack = this.shader.copy();
                this.shader = ItemStack.EMPTY;
                this.markDirty();
                this.container.onCraftMatrixChanged((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = this.shader.splitStack(j);
            if (this.shader.getCount() == 0) {
                this.shader = ItemStack.EMPTY;
            }
            this.container.onCraftMatrixChanged((IInventory)this);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int i, ItemStack stack) {
        this.shader = stack;
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        }
        this.container.onCraftMatrixChanged((IInventory)this);
    }

    public String getName() {
        return "container." + this.name;
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        if (this.wrapper != null) {
            this.wrapper.setShaderItem(this.shader);
        }
    }

    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }
}

