/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.ContainerAutoWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.items.ItemBullet;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class IESlot
extends Slot {
    final Container container;

    public IESlot(Container container, IInventory inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.container = container;
    }

    public boolean isItemValid(ItemStack itemStack) {
        return true;
    }

    public static interface ICallbackContainer {
        public boolean canInsert(ItemStack var1, int var2, Slot var3);

        public boolean canTake(ItemStack var1, int var2, Slot var3);
    }

    public static class ContainerCallback
    extends SlotItemHandler {
        Container container;

        public ContainerCallback(Container container, IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
            this.container = container;
        }

        public boolean isItemValid(ItemStack itemStack) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canInsert(itemStack, this.slotNumber, (Slot)this);
            }
            return true;
        }

        public boolean canTakeStack(EntityPlayer player) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canTake(this.getStack(), this.slotNumber, (Slot)this);
            }
            return true;
        }
    }

    public static class Belljar
    extends IESlot {
        int type = 0;

        public Belljar(int type, Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
            this.type = type;
        }

        public int getSlotStackLimit() {
            return this.type < 2 ? 1 : 64;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && (this.type == 1 ? BelljarHandler.getHandler(itemStack) != null : this.type != 2 || BelljarHandler.getItemFertilizerHandler(itemStack) != null);
        }
    }

    public static class ArcElectrode
    extends IESlot {
        public ArcElectrode(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public int getSlotStackLimit() {
            return 1;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && IEContent.itemGraphiteElectrode.equals(itemStack.getItem());
        }
    }

    public static class ArcAdditive
    extends IESlot {
        public ArcAdditive(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && ArcFurnaceRecipe.isValidRecipeAdditive(itemStack);
        }
    }

    public static class ArcInput
    extends IESlot {
        public ArcInput(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && ArcFurnaceRecipe.isValidRecipeInput(itemStack);
        }
    }

    public static class BlueprintOutput
    extends SlotItemHandler {
        public BlueprintCraftingRecipe recipe;
        ItemStack upgradeableTool;
        Container container;

        public BlueprintOutput(Container container, IItemHandler inv, int id, int x, int y, ItemStack upgradeableTool, BlueprintCraftingRecipe recipe) {
            super(inv, id, x, y);
            this.container = container;
            this.upgradeableTool = upgradeableTool;
            this.recipe = recipe;
        }

        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean isEnabled() {
            return this.getHasStack();
        }

        public ItemStack onTake(EntityPlayer player, ItemStack stack) {
            if (!this.upgradeableTool.isEmpty() && this.upgradeableTool.getItem() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.getItem()).reduceInputs(this.recipe, this.upgradeableTool, stack, this.container);
                ((ItemEngineersBlueprint)this.upgradeableTool.getItem()).updateOutputs(this.upgradeableTool);
            }
            this.inventory.markDirty();
            return super.onTake(player, stack);
        }
    }

    public static class BlueprintInput
    extends SlotItemHandler {
        ItemStack upgradeableTool;
        Container container;

        public BlueprintInput(Container container, IItemHandler inv, int id, int x, int y, ItemStack upgradeableTool) {
            super(inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
        }

        public void onSlotChanged() {
            if (!this.upgradeableTool.isEmpty() && this.upgradeableTool.getItem() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.getItem()).updateOutputs(this.upgradeableTool);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
            super.onSlotChanged();
        }

        public int getSlotStackLimit() {
            return 64;
        }
    }

    public static class ItemDisplay
    extends IESlot {
        public ItemDisplay(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        public boolean canTakeStack(EntityPlayer player) {
            return false;
        }
    }

    public static class Ghost
    extends IESlot {
        public Ghost(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public void putStack(ItemStack itemStack) {
            super.putStack(itemStack);
        }

        public boolean canTakeStack(EntityPlayer player) {
            return false;
        }

        public int getSlotStackLimit() {
            return 1;
        }
    }

    public static class AutoBlueprint
    extends IESlot {
        public AutoBlueprint(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && itemStack.getItem() instanceof ItemEngineersBlueprint;
        }

        public int getSlotStackLimit() {
            return 1;
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (this.container instanceof ContainerAutoWorkbench) {
                ImmersiveEngineering.proxy.reInitGui();
            }
        }
    }

    public static class UpgradeableItem
    extends IESlot {
        int size;

        public UpgradeableItem(Container container, IInventory inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            if (itemStack.isEmpty()) {
                return false;
            }
            if (itemStack.getItem() instanceof IUpgradeableTool) {
                return ((IUpgradeableTool)itemStack.getItem()).canModify(itemStack);
            }
            if (itemStack.getItem() instanceof IConfigurableTool) {
                return ((IConfigurableTool)itemStack.getItem()).canConfigure(itemStack);
            }
            return false;
        }

        public int getSlotStackLimit() {
            return this.size;
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
        }

        public boolean canTakeStack(EntityPlayer player) {
            return this.getStack().isEmpty() || !(this.getStack().getItem() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.getStack().getItem()).canTakeFromWorkbench(this.getStack());
        }

        public ItemStack onTake(EntityPlayer player, ItemStack stack) {
            IItemHandler handler;
            ItemStack result = super.onTake(player, stack);
            if (!stack.isEmpty() && stack.getItem() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.getItem()).removeFromWorkbench(player, stack);
            }
            if ((handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) instanceof IEItemStackHandler) {
                ((IEItemStackHandler)handler).setTile(null);
            }
            return result;
        }
    }

    public static class Shader
    extends IESlot {
        ItemStack tool;

        public Shader(Container container, IInventory inv, int id, int x, int y, ItemStack tool) {
            super(container, inv, id, x, y);
            this.tool = tool;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.setBackgroundName("immersiveengineering:items/shader_slot");
            }
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            if (itemStack.isEmpty() || !(itemStack.getItem() instanceof IShaderItem) || this.tool.isEmpty() || !this.tool.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
                return false;
            }
            CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)this.tool.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (wrapper == null) {
                return false;
            }
            return ((IShaderItem)itemStack.getItem()).getShaderCase(itemStack, this.tool, wrapper.getShaderType()) != null;
        }

        public int getSlotStackLimit() {
            return 1;
        }
    }

    public static class Upgrades
    extends SlotItemHandler {
        ItemStack upgradeableTool;
        String type;
        boolean preventDoubles;
        Container container;

        public Upgrades(Container container, IItemHandler inv, int id, int x, int y, String type, ItemStack upgradeableTool, boolean preventDoubles) {
            super(inv, id, x, y);
            this.container = container;
            this.type = type;
            this.upgradeableTool = upgradeableTool;
            this.preventDoubles = preventDoubles;
        }

        public boolean isItemValid(ItemStack itemStack) {
            if (this.preventDoubles) {
                for (Slot slot : this.container.inventorySlots) {
                    if (!(slot instanceof Upgrades) || !((Upgrades)slot).preventDoubles || !OreDictionary.itemMatches((ItemStack)slot.getStack(), (ItemStack)itemStack, (boolean)true)) continue;
                    return false;
                }
            }
            return !itemStack.isEmpty() && itemStack.getItem() instanceof IUpgrade && ((IUpgrade)itemStack.getItem()).getUpgradeTypes(itemStack).contains(this.type) && ((IUpgrade)itemStack.getItem()).canApplyUpgrades(this.upgradeableTool, itemStack);
        }

        public int getSlotStackLimit() {
            return 64;
        }

        public void onSlotChanged() {
            ((IUpgradeableTool)this.upgradeableTool.getItem()).recalculateUpgrades(this.upgradeableTool);
        }
    }

    public static class DrillHead
    extends SlotItemHandler {
        public DrillHead(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && itemStack.getItem() instanceof IDrillHead;
        }

        public int getSlotStackLimit() {
            return 1;
        }
    }

    public static class Bullet
    extends SlotItemHandler {
        int limit;

        public Bullet(IItemHandler inv, int id, int x, int y, int limit) {
            super(inv, id, x, y);
            this.limit = limit;
        }

        public boolean isItemValid(ItemStack itemStack) {
            return !itemStack.isEmpty() && itemStack.getItem() instanceof ItemBullet;
        }

        public int getSlotStackLimit() {
            return this.limit;
        }

        public int getItemStackLimit(@Nonnull ItemStack stack) {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends IESlot {
        public BlastFuel(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return BlastFurnaceRecipe.isValidBlastFuel(itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        boolean empty;

        public FluidContainer(Container container, IInventory inv, int id, int x, int y, boolean empty) {
            super(container, inv, id, x, y);
            this.empty = empty;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)itemStack);
            if (handler == null || handler.getTankProperties() == null) {
                return false;
            }
            IFluidTankProperties[] tank = handler.getTankProperties();
            if (tank == null || tank.length < 1 || tank[0] == null) {
                return false;
            }
            if (this.empty) {
                return tank[0].getContents() == null;
            }
            return tank[0].getContents() != null;
        }
    }

    public static class Output
    extends IESlot {
        public Output(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }
    }
}

