/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.gui.ContainerIEBase;
import blusunrize.immersiveengineering.common.gui.IESlot;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ContainerRefinery
extends ContainerIEBase<TileEntityRefinery> {
    public ContainerRefinery(InventoryPlayer inventoryPlayer, TileEntityRefinery tile) {
        super(inventoryPlayer, tile);
        int i;
        final TileEntityRefinery tileF = tile;
        this.addSlotToContainer(new IESlot.FluidContainer(this, this.inv, 0, 37, 15, false){

            @Override
            public boolean isItemValid(ItemStack itemStack) {
                IFluidHandler h = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (h == null || h.getTankProperties().length == 0) {
                    return false;
                }
                FluidStack fs = h.getTankProperties()[0].getContents();
                if (fs == null) {
                    return false;
                }
                if (RefineryRecipe.findIncompleteRefineryRecipe(fs, null) == null) {
                    return false;
                }
                if (tileF.tanks[0].getFluidAmount() > 0 && !fs.isFluidEqual(tileF.tanks[0].getFluid())) {
                    return false;
                }
                if (tileF.tanks[1].getFluidAmount() <= 0) {
                    return true;
                }
                List<RefineryRecipe> incomplete = RefineryRecipe.findIncompleteRefineryRecipe(fs, tileF.tanks[1].getFluid());
                return incomplete != null && !incomplete.isEmpty();
            }
        });
        this.addSlotToContainer(new IESlot.Output(this, this.inv, 1, 37, 54));
        this.addSlotToContainer(new IESlot.FluidContainer(this, this.inv, 2, 85, 15, false){

            @Override
            public boolean isItemValid(ItemStack itemStack) {
                IFluidHandler h = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (h == null || h.getTankProperties().length == 0) {
                    return false;
                }
                FluidStack fs = h.getTankProperties()[0].getContents();
                if (fs == null) {
                    return false;
                }
                if (RefineryRecipe.findIncompleteRefineryRecipe(fs, null) == null) {
                    return false;
                }
                if (tileF.tanks[1].getFluidAmount() > 0 && !fs.isFluidEqual(tileF.tanks[1].getFluid())) {
                    return false;
                }
                if (tileF.tanks[0].getFluidAmount() <= 0) {
                    return true;
                }
                List<RefineryRecipe> incomplete = RefineryRecipe.findIncompleteRefineryRecipe(fs, tileF.tanks[0].getFluid());
                return incomplete != null && !incomplete.isEmpty();
            }
        });
        this.addSlotToContainer(new IESlot.Output(this, this.inv, 3, 85, 54));
        this.addSlotToContainer(new IESlot.FluidContainer(this, this.inv, 4, 133, 15, true){

            @Override
            public boolean isItemValid(ItemStack itemStack) {
                return super.isItemValid(itemStack) || !itemStack.isEmpty() && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            }
        });
        this.addSlotToContainer(new IESlot.Output(this, this.inv, 5, 133, 54));
        this.slotCount = 6;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 143));
        }
    }
}

