/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class ContainerInternalStorageItem
extends Container {
    protected World world;
    protected int blockedSlot;
    public IItemHandler inv;
    protected EntityEquipmentSlot equipmentSlot = null;
    protected ItemStack heldItem = ItemStack.EMPTY;
    protected EntityPlayer player = null;
    public final int internalSlots;

    public ContainerInternalStorageItem(InventoryPlayer iinventory, World world, EntityEquipmentSlot entityEquipmentSlot, ItemStack heldItem) {
        this.world = world;
        this.player = iinventory.player;
        this.equipmentSlot = entityEquipmentSlot;
        this.heldItem = heldItem;
        this.inv = (IItemHandler)heldItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (this.inv instanceof IEItemStackHandler) {
            ((IEItemStackHandler)this.inv).setInventoryForUpdate((IInventory)iinventory);
        }
        this.internalSlots = this.addSlots(iinventory);
        this.blockedSlot = iinventory.currentItem + 27 + this.internalSlots;
    }

    abstract int addSlots(InventoryPlayer var1);

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slot) {
        ItemStack oldStackInSlot = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            oldStackInSlot = stackInSlot.copy();
            if (slot < this.internalSlots) {
                if (!this.mergeItemStack(stackInSlot, this.internalSlots, this.internalSlots + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.allowShiftclicking() && !stackInSlot.isEmpty()) {
                boolean b = true;
                for (int i = 0; i < this.internalSlots; ++i) {
                    Slot s = (Slot)this.inventorySlots.get(i);
                    if (s == null || !s.isItemValid(stackInSlot) || !s.getStack().isEmpty() && (!ItemStack.areItemsEqual((ItemStack)stackInSlot, (ItemStack)s.getStack()) || !Utils.compareItemNBT(stackInSlot, s.getStack()))) continue;
                    int space = Math.min(s.getItemStackLimit(stackInSlot), stackInSlot.getMaxStackSize());
                    if (!s.getStack().isEmpty()) {
                        space -= s.getStack().getCount();
                    }
                    if (space <= 0) continue;
                    ItemStack insert = stackInSlot;
                    if (space < stackInSlot.getCount()) {
                        insert = stackInSlot.splitStack(space);
                    }
                    if (!this.mergeItemStack(insert, i, i + 1, true)) continue;
                    b = false;
                }
                if (b) {
                    return ItemStack.EMPTY;
                }
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.putStack(ItemStack.EMPTY);
            } else {
                slotObject.onSlotChanged();
            }
            slotObject.inventory.markDirty();
            if (stackInSlot.getCount() == oldStackInSlot.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(this.player, oldStackInSlot);
            this.updatePlayerItem();
            this.detectAndSendChanges();
        }
        return oldStackInSlot;
    }

    protected boolean allowShiftclicking() {
        return true;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack slotClick(int par1, int par2, ClickType par3, EntityPlayer par4EntityPlayer) {
        if (par1 == this.blockedSlot || par3 == ClickType.SWAP && par2 == par4EntityPlayer.inventory.currentItem) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = super.slotClick(par1, par2, par3, par4EntityPlayer);
        this.updatePlayerItem();
        return ret;
    }

    public void onContainerClosed(EntityPlayer par1EntityPlayer) {
        super.onContainerClosed(par1EntityPlayer);
        if (!this.world.isRemote) {
            this.updatePlayerItem();
        }
        if (this.inv instanceof IEItemStackHandler) {
            ((IEItemStackHandler)this.inv).setInventoryForUpdate(null);
        }
    }

    protected void updatePlayerItem() {
    }
}

