/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.InventoryTile;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ContainerIEBase<T extends TileEntity>
extends Container {
    public T tile;
    public IInventory inv;
    public int slotCount;

    public ContainerIEBase(InventoryPlayer inventoryPlayer, T tile) {
        this.tile = tile;
        this.inv = new InventoryTile((TileEntity)tile);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.inv.isUsableByPlayer(player);
    }

    public ItemStack slotClick(int id, int button, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = id < 0 ? null : (Slot)this.inventorySlots.get(id);
        if (!(slot instanceof IESlot.Ghost)) {
            return super.slotClick(id, button, clickType, player);
        }
        ItemStack stack = ItemStack.EMPTY;
        ItemStack stackSlot = slot.getStack();
        if (!stackSlot.isEmpty()) {
            stack = stackSlot.copy();
        }
        if (button == 2) {
            slot.putStack(ItemStack.EMPTY);
        } else if (button == 0 || button == 1) {
            InventoryPlayer playerInv = player.inventory;
            ItemStack stackHeld = playerInv.getItemStack();
            if (stackSlot.isEmpty()) {
                if (!stackHeld.isEmpty() && slot.isItemValid(stackHeld)) {
                    slot.putStack(Utils.copyStackWithAmount(stackHeld, 1));
                }
            } else if (stackHeld.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else if (slot.isItemValid(stackHeld)) {
                slot.putStack(Utils.copyStackWithAmount(stackHeld, 1));
            }
        } else if (button == 5) {
            InventoryPlayer playerInv = player.inventory;
            ItemStack stackHeld = playerInv.getItemStack();
            if (!slot.getHasStack()) {
                slot.putStack(Utils.copyStackWithAmount(stackHeld, 1));
            }
        }
        return stack;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (slot < this.slotCount) {
                if (!this.mergeItemStack(stackInSlot, this.slotCount, this.slotCount + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                boolean b = false;
                for (int i = 0; i < this.slotCount; ++i) {
                    if (!this.getSlot(i).isItemValid(stackInSlot) || !this.mergeItemStack(stackInSlot, i, i + 1, false)) continue;
                    b = true;
                    break;
                }
                if (!b) {
                    return ItemStack.EMPTY;
                }
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.putStack(ItemStack.EMPTY);
            } else {
                slotObject.onSlotChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(player, stackInSlot);
        }
        return stack;
    }

    protected boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack stackInSlot;
        Slot slot;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex)) {
                slot = (Slot)this.inventorySlots.get(i);
                stackInSlot = slot.getStack();
                if (!stackInSlot.isEmpty() && ContainerIEBase.areItemStacksEqual(stack, stackInSlot)) {
                    int maxSize;
                    int j = stackInSlot.getCount() + stack.getCount();
                    if (j <= (maxSize = Math.min(slot.getSlotStackLimit(), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        stackInSlot.setCount(j);
                        slot.onSlotChanged();
                        flag = true;
                    } else if (stackInSlot.getCount() < maxSize) {
                        stack.shrink(maxSize - stackInSlot.getCount());
                        stackInSlot.setCount(maxSize);
                        slot.onSlotChanged();
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex) {
                slot = (Slot)this.inventorySlots.get(i);
                stackInSlot = slot.getStack();
                if (stackInSlot.isEmpty() && slot.isItemValid(stack)) {
                    int maxSize = Math.min(slot.getSlotStackLimit(), stack.getMaxStackSize());
                    if (stack.getCount() <= maxSize) {
                        slot.putStack(stack.copy());
                        slot.onSlotChanged();
                        stack.setCount(0);
                        flag = true;
                        break;
                    }
                    slot.putStack(Utils.copyStackWithAmount(stack, maxSize));
                    slot.onSlotChanged();
                    stack.shrink(maxSize);
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    private static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return stackB.getItem() == stackA.getItem() && (!stackA.getHasSubtypes() || stackA.getMetadata() == stackB.getMetadata()) && ItemStack.areItemStackTagsEqual((ItemStack)stackA, (ItemStack)stackB);
    }

    public void onContainerClosed(EntityPlayer playerIn) {
        super.onContainerClosed(playerIn);
        this.inv.closeInventory(playerIn);
    }
}

