/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAutoWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerIEBase;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAutoWorkbench
extends ContainerIEBase<TileEntityAutoWorkbench> {
    public InventoryPlayer inventoryPlayer;

    public ContainerAutoWorkbench(InventoryPlayer inventoryPlayer, TileEntityAutoWorkbench tile) {
        super(inventoryPlayer, tile);
        this.inventoryPlayer = inventoryPlayer;
        this.addSlotToContainer(new IESlot.AutoBlueprint(this, this.inv, 0, 102, 69));
        for (int i = 0; i < 16; ++i) {
            this.addSlotToContainer(new Slot(this.inv, 1 + i, 7 + i % 4 * 18, 24 + i / 4 * 18));
        }
        this.slotCount = 17;
        this.bindPlayerInv(inventoryPlayer);
    }

    private void bindPlayerInv(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 103 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 161));
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, int slot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.inventorySlots.get(slot);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (slot < this.slotCount) {
                if (!this.mergeItemStack(stackInSlot, this.slotCount, this.slotCount + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!stackInSlot.isEmpty()) {
                if (stackInSlot.getItem() instanceof ItemEngineersBlueprint) {
                    if (!this.mergeItemStack(stackInSlot, 0, 1, true)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    boolean b = true;
                    for (int i = 1; i < this.slotCount; ++i) {
                        Slot s = (Slot)this.inventorySlots.get(i);
                        if (s == null || !s.isItemValid(stackInSlot) || !this.mergeItemStack(stackInSlot, i, i + 1, true)) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.putStack(ItemStack.EMPTY);
            } else {
                slotObject.onSlotChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(player, stack);
        }
        return stack;
    }

    public void onCraftMatrixChanged(IInventory p_75130_1_) {
        super.onCraftMatrixChanged(p_75130_1_);
        ((TileEntityAutoWorkbench)this.tile).markContainingBlockForUpdate(null);
    }
}

