/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageSkyhookSync;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySkylineHook
extends Entity {
    public ImmersiveNetHandler.Connection connection;
    public BlockPos target;
    public Vec3d[] subPoints;
    public int targetPoint = 0;

    public EntitySkylineHook(World world) {
        super(world);
        this.setSize(0.125f, 0.125f);
    }

    public EntitySkylineHook(World world, double x, double y, double z, ImmersiveNetHandler.Connection connection, BlockPos target, Vec3d[] subPoints) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
        this.setPosition(x, y, z);
        this.connection = connection;
        this.target = target;
        this.subPoints = subPoints;
        float f1 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
        this.rotationPitch = (float)(Math.atan2(f1, this.motionY) * 180.0 / Math.PI) - 90.0f;
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
    }

    protected void entityInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_70112_1_) {
        double d1 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public void onUpdate() {
        EntityPlayer player = null;
        List list = this.getPassengers();
        if (!list.isEmpty() && list.get(0) instanceof EntityPlayer) {
            player = (EntityPlayer)list.get(0);
        }
        if (this.ticksExisted == 1 && !this.world.isRemote) {
            IELogger.debug("init tick at " + System.currentTimeMillis());
            if (player instanceof EntityPlayerMP) {
                ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSkyhookSync(this), (EntityPlayerMP)player);
            }
        }
        super.onUpdate();
        if (this.subPoints != null && this.targetPoint < this.subPoints.length - 1) {
            double dist = this.subPoints[this.targetPoint].distanceTo(new Vec3d(this.posX, this.posY, this.posZ));
            IELogger.debug("dist: " + dist);
            if (dist <= 0.0) {
                this.posX = this.subPoints[this.targetPoint].x;
                this.posY = this.subPoints[this.targetPoint].y;
                this.posZ = this.subPoints[this.targetPoint].z;
                ++this.targetPoint;
                if (player instanceof EntityPlayerMP) {
                    ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSkyhookSync(this), (EntityPlayerMP)player);
                }
                IELogger.debug("next vertex: " + this.targetPoint);
                return;
            }
            float speed = 2.0f;
            if (player != null && !player.getActiveItemStack().isEmpty() && player.getActiveItemStack().getItem() instanceof ItemSkyhook) {
                speed = ((ItemSkyhook)player.getActiveItemStack().getItem()).getSkylineSpeed(player.getActiveItemStack());
            }
            Vec3d moveVec = SkylineHelper.getSubMovementVector(new Vec3d(this.posX, this.posY, this.posZ), this.subPoints[this.targetPoint], speed);
            this.motionX = moveVec.x;
            this.motionY = moveVec.y;
            this.motionZ = moveVec.z;
        }
        if (this.target != null && this.targetPoint == this.subPoints.length - 1) {
            TileEntity end = this.world.getTileEntity(this.target);
            IImmersiveConnectable iicEnd = ApiUtils.toIIC(end, this.world);
            if (iicEnd == null) {
                this.setDead();
                return;
            }
            Vec3d vEnd = new Vec3d((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ());
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(this.connection));
            double gDist = vEnd.distanceTo(new Vec3d(this.posX, this.posY, this.posZ));
            IELogger.debug("distance to goal: " + gDist);
            if (gDist <= 0.3) {
                this.reachedTarget(end);
                return;
            }
            if (gDist > 5.0) {
                this.setDead();
                return;
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f1 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
        this.rotationPitch = (float)(Math.atan2(f1, this.motionY) * 180.0 / Math.PI) - 90.0f;
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ, new int[0]);
            }
        }
        if (player != null) {
            double dx = this.posX - this.prevPosX;
            double dy = this.posY - this.prevPosY;
            double dz = this.posZ - this.prevPosZ;
            int distTrvl = Math.round(MathHelper.sqrt((double)(dx * dx + dy * dy + dz * dz)) * 100.0f);
            if (this.world.isRemote || SkylineHelper.isInBlock(player, this.world)) {
                // empty if block
            }
        }
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public void reachedTarget(TileEntity end) {
        this.setDead();
        IELogger.debug("last tick at " + System.currentTimeMillis());
        List list = this.getPassengers();
        if (list.isEmpty() || !(list.get(0) instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)list.get(0);
        ItemStack hook = player.getActiveItemStack();
        if (hook.isEmpty() || !(hook.getItem() instanceof ItemSkyhook)) {
            return;
        }
        ImmersiveNetHandler.Connection line = SkylineHelper.getTargetConnection(this.world, this.target, (EntityLivingBase)player, this.connection);
        if (line != null) {
            player.setActiveHand(player.getActiveHand());
            SkylineHelper.spawnHook(player, end, line);
        } else {
            player.motionX = this.motionX;
            player.motionY = this.motionY;
            player.motionZ = this.motionZ;
            IELogger.debug("player motion: " + player.motionX + "," + player.motionY + "," + player.motionZ);
        }
    }

    public Vec3d getLookVec() {
        float f1 = MathHelper.cos((float)(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.sin((float)(-this.rotationYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.cos((float)(-this.rotationPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.sin((float)(-this.rotationPitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    @Nullable
    public Entity getControllingPassenger() {
        return null;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean canRenderOnFire() {
        return false;
    }

    public boolean isPushedByWater() {
        return false;
    }

    public double getMountedYOffset() {
        return -2.0;
    }

    protected void writeEntityToNBT(NBTTagCompound nbt) {
    }

    protected void readEntityFromNBT(NBTTagCompound nbt) {
    }

    public float getCollisionBorderSize() {
        return 0.0f;
    }

    public float getBrightness() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        this.setDead();
        return true;
    }
}

