/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRevolvershotHoming
extends EntityRevolvershot {
    public int trackCountdown = 5;
    public double redirectionSpeed = 0.25;
    public EntityLivingBase targetOverride;

    public EntityRevolvershotHoming(World world) {
        super(world);
    }

    public EntityRevolvershotHoming(World world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(world, x, y, z, ax, ay, az, type);
    }

    public EntityRevolvershotHoming(World world, EntityLivingBase living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        super(world, living, ax, ay, az, type, stack);
    }

    @Override
    public void onUpdate() {
        EntityLivingBase target;
        super.onUpdate();
        if (!this.world.isRemote && this.ticksExisted > this.trackCountdown && (target = this.getTarget()) != null) {
            Vec3d newMotion = new Vec3d(this.motionX * (1.0 - this.redirectionSpeed) + (target.posX - this.posX) * this.redirectionSpeed, this.motionY * (1.0 - this.redirectionSpeed) + (target.posY + (double)(target.height / 2.0f) - this.posY) * this.redirectionSpeed, this.motionZ * (1.0 - this.redirectionSpeed) + (target.posZ - this.posZ) * this.redirectionSpeed).normalize();
            this.motionX = newMotion.x;
            this.motionY = newMotion.y;
            this.motionZ = newMotion.z;
        }
    }

    public EntityLivingBase getTarget() {
        if (this.targetOverride != null && !this.targetOverride.isDead) {
            return this.targetOverride;
        }
        double r = 20.0;
        AxisAlignedBB aabb = new AxisAlignedBB(this.posX - r, this.posY - r, this.posZ - r, this.posX + r, this.posY + r, this.posZ + r);
        EntityLivingBase target = null;
        for (Object o : this.world.getEntitiesWithinAABB(EntityLivingBase.class, aabb)) {
            if (!(o instanceof EntityLivingBase) || o.equals(this.shootingEntity) || target != null && !(((EntityLivingBase)o).getDistanceSqToEntity((Entity)this) < target.getDistanceSqToEntity((Entity)this))) continue;
            target = (EntityLivingBase)o;
        }
        return target;
    }
}

