/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.util.Utils;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityRevolvershotFlare
extends EntityRevolvershot
implements ILightProvider {
    boolean shootUp = false;
    public int colour = -1;
    private static final DataParameter<Integer> dataMarker_colour = EntityDataManager.createKey(EntityRevolvershotFlare.class, (DataSerializer)DataSerializers.VARINT);
    private BlockPos lightPos;

    public EntityRevolvershotFlare(World world) {
        super(world);
        this.setTickLimit(400);
    }

    public EntityRevolvershotFlare(World world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(world, x, y, z, ax, ay, az, type);
        this.setTickLimit(400);
    }

    public EntityRevolvershotFlare(World world, EntityLivingBase living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        super(world, living, ax, ay, az, type, stack);
        this.setTickLimit(400);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(dataMarker_colour, (Object)-1);
    }

    public void setColourSynced() {
        this.dataManager.set(dataMarker_colour, (Object)this.colour);
    }

    public int getColourSynced() {
        return (Integer)this.dataManager.get(dataMarker_colour);
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void onUpdate() {
        Vec3d v;
        int i;
        float b;
        float g;
        float r;
        super.onUpdate();
        if (this.colour < 0) {
            this.colour = this.getColourSynced();
        }
        if (this.world.isRemote && this.ticksExisted % 1 == 0) {
            r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
            g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
            b = (float)(this.getColour() & 0xFF) / 255.0f;
            ImmersiveEngineering.proxy.spawnRedstoneFX(this.world, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, 1.0f, r, g, b);
            if (this.ticksExisted > 40) {
                for (i = 0; i < 20; ++i) {
                    v = new Vec3d(Utils.RAND.nextDouble() - 0.5, Utils.RAND.nextDouble() - 0.5, Utils.RAND.nextDouble() - 0.5);
                    ImmersiveEngineering.proxy.spawnRedstoneFX(this.world, this.posX + v.x, this.posY + v.y, this.posZ + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0, 1.0f, r, g, b);
                }
            }
        }
        if (this.ticksExisted == 40) {
            this.motionX = 0.0;
            this.motionY = -0.1;
            this.motionZ = 0.0;
            r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
            g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
            b = (float)(this.getColour() & 0xFF) / 255.0f;
            for (i = 0; i < 80; ++i) {
                v = new Vec3d((Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0);
                ImmersiveEngineering.proxy.spawnRedstoneFX(this.world, this.posX + v.x, this.posY + v.y, this.posZ + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0, 1.0f, r, g, b);
            }
            this.lightPos = this.getPosition();
            for (i = 0; i < 128; ++i) {
                if (!this.world.isAirBlock(this.lightPos)) {
                    this.lightPos = this.lightPos.up(6);
                    break;
                }
                this.lightPos = this.lightPos.down();
            }
        }
    }

    @Override
    protected void onImpact(RayTraceResult mop) {
        if (this.ticksExisted <= 40) {
            if (!this.world.isRemote) {
                BlockPos pos;
                if (mop.entityHit != null) {
                    if (!mop.entityHit.isImmuneToFire()) {
                        mop.entityHit.setFire(8);
                    }
                } else if (mop.getBlockPos() != null && this.world.isAirBlock(pos = mop.getBlockPos().offset(mop.sideHit))) {
                    this.world.setBlockState(pos, Blocks.FIRE.getDefaultState());
                }
            }
            float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.getColour() & 0xFF) / 255.0f;
            for (int i = 0; i < 80; ++i) {
                Vec3d v = new Vec3d((Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0);
                ImmersiveEngineering.proxy.spawnRedstoneFX(this.world, this.posX + v.x, this.posY + v.y, this.posZ + v.z, v.x / 10.0, v.y / 10.0, v.z / 10.0, 1.0f, r, g, b);
            }
        }
        this.setDead();
    }

    @Nullable
    @Optional.Method(modid="albedo")
    @SideOnly(value=Side.CLIENT)
    public Light provideLight() {
        float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.getColour() & 0xFF) / 255.0f;
        if (this.lightPos != null) {
            return Light.builder().pos(this.lightPos).radius(16.0f).color(r, g, b).build();
        }
        return Light.builder().pos((Entity)this).radius(1.0f).color(r, g, b).build();
    }
}

