/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageBirthdayParty;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRevolvershot
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private boolean inGround;
    public EntityLivingBase shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private float movementDecay = 0.0f;
    private float gravity = 0.0f;
    private int tickLimit = 40;
    String bulletType;
    public boolean bulletElectro = false;
    public ItemStack bulletPotion = ItemStack.EMPTY;
    private static final DataParameter<String> dataMarker_shooter = EntityDataManager.createKey(EntityRevolvershot.class, (DataSerializer)DataSerializers.STRING);

    public EntityRevolvershot(World world) {
        super(world);
        this.setSize(0.125f, 0.125f);
    }

    public EntityRevolvershot(World world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
        this.setPosition(x, y, z);
        this.bulletType = BulletHandler.findRegistryName(type);
    }

    public EntityRevolvershot(World world, EntityLivingBase living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        this(world, living, ax, ay, az, BulletHandler.findRegistryName(type), stack);
    }

    public EntityRevolvershot(World world, EntityLivingBase living, double ax, double ay, double az, String type, ItemStack stack) {
        super(world);
        this.shootingEntity = living;
        this.setShooterSynced();
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(living.posX + ax, living.posY + (double)living.getEyeHeight() + ay, living.posZ + az, living.rotationYaw, living.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.bulletType = type;
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setMovementDecay(float f) {
        this.movementDecay = f;
    }

    public void setGravity(float f) {
        this.gravity = f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_70112_1_) {
        double d1 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    protected void entityInit() {
        this.dataManager.register(dataMarker_shooter, (Object)"");
    }

    public void setShooterSynced() {
        this.dataManager.set(dataMarker_shooter, (Object)this.shootingEntity.getName());
    }

    public EntityLivingBase getShooterSynced() {
        return this.world.getPlayerEntityByName((String)this.dataManager.get(dataMarker_shooter));
    }

    public Entity getShooter() {
        return this.shootingEntity;
    }

    public void onUpdate() {
        if (this.getShooter() == null && this.world.isRemote) {
            this.shootingEntity = this.getShooterSynced();
        }
        if (!this.world.isRemote && this.shootingEntity != null && this.shootingEntity.isDead) {
            this.setDead();
        } else {
            AxisAlignedBB axisalignedbb;
            BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
            IBlockState iblockstate = this.world.getBlockState(blockpos);
            Block block = iblockstate.getBlock();
            if (iblockstate.getMaterial() != Material.AIR && (axisalignedbb = iblockstate.getCollisionBoundingBox((IBlockAccess)this.world, blockpos)) != null && axisalignedbb.contains(new Vec3d(this.posX, this.posY, this.posZ))) {
                this.inGround = true;
            }
            super.onUpdate();
            if (this.inGround) {
                int j = block.getMetaFromState(iblockstate);
                if (block == this.inTile && j == this.inData) {
                    ++this.ticksInGround;
                    if (this.ticksInGround >= 1200) {
                        this.setDead();
                    }
                } else {
                    this.inGround = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                    this.ticksInGround = 0;
                    this.ticksInAir = 0;
                }
            } else {
                ++this.ticksInAir;
            }
            if (this.ticksInAir >= this.tickLimit) {
                this.onExpire();
                this.setDead();
                return;
            }
            Vec3d vec3 = new Vec3d(this.posX, this.posY, this.posZ);
            Vec3d vec31 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            RayTraceResult movingobjectposition = this.world.rayTraceBlocks(vec3, vec31);
            vec3 = new Vec3d(this.posX, this.posY, this.posZ);
            vec31 = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            if (movingobjectposition != null) {
                vec31 = new Vec3d(movingobjectposition.hitVec.x, movingobjectposition.hitVec.y, movingobjectposition.hitVec.z);
            }
            Entity entity = null;
            List list = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().offset(this.motionX, this.motionY, this.motionZ).grow(1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.canBeCollidedWith() || entity1.isEntityEqual((Entity)this.shootingEntity)) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb2 = entity1.getEntityBoundingBox().grow((double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb2.calculateIntercept(vec3, vec31);
                if (movingobjectposition1 == null || !((d1 = vec3.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null) {
                this.onImpact(movingobjectposition);
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float f1 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) + 90.0f;
            this.rotationPitch = (float)(Math.atan2(f1, this.motionY) * 180.0 / Math.PI) - 90.0f;
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float decay = this.movementDecay;
            if (this.isInWater()) {
                float f3 = 0.25f;
                for (int j = 0; j < 4; ++j) {
                    this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ, new int[0]);
                }
                decay = (float)((double)decay * 0.6);
            }
            if (decay != 0.0f) {
                this.motionX *= (double)decay;
                this.motionY *= (double)decay;
                this.motionZ *= (double)decay;
            }
            if (this.gravity != 0.0f) {
                this.motionY -= (double)this.gravity;
            }
            if (this.ticksExisted % 4 == 0) {
                this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0, new int[0]);
            }
            this.setPosition(this.posX, this.posY, this.posZ);
        }
    }

    protected void onImpact(RayTraceResult mop) {
        boolean headshot = false;
        if (mop.entityHit instanceof EntityLivingBase) {
            headshot = Utils.isVecInEntityHead((EntityLivingBase)mop.entityHit, new Vec3d(this.posX, this.posY, this.posZ));
        }
        if (this.bulletType != null) {
            BulletHandler.IBullet bullet = BulletHandler.getBullet(this.bulletType);
            if (bullet != null) {
                bullet.onHitTarget(this.world, mop, this.shootingEntity, this, headshot);
            }
            if (headshot && mop.entityHit instanceof EntityAgeable && ((EntityAgeable)mop.entityHit).isChild() && ((EntityLivingBase)mop.entityHit).getHealth() <= 0.0f) {
                if (this.shootingEntity instanceof EntityPlayer) {
                    Utils.unlockIEAdvancement((EntityPlayer)this.shootingEntity, "main/secret_birthdayparty");
                }
                this.world.playSound(null, this.posX, this.posY, this.posZ, IESounds.birthdayParty, SoundCategory.PLAYERS, 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                ImmersiveEngineering.packetHandler.sendToDimension((IMessage)new MessageBirthdayParty((EntityLivingBase)mop.entityHit), this.world.provider.getDimension());
            }
        }
        if (!this.world.isRemote) {
            this.secondaryImpact(mop);
        }
        this.setDead();
    }

    public void secondaryImpact(RayTraceResult mop) {
        if (this.bulletElectro && mop.entityHit instanceof EntityLivingBase) {
            BulletHandler.IBullet bullet = BulletHandler.getBullet(this.bulletType);
            float percentualDrain = 0.15f / (float)(bullet == null ? 1 : bullet.getProjectileCount(this.shootingEntity instanceof EntityPlayer ? (EntityPlayer)this.shootingEntity : null));
            ((EntityLivingBase)mop.entityHit).addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 15, 4));
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                int actualDrain;
                ItemStack stack = ((EntityLivingBase)mop.entityHit).getItemStackFromSlot(slot);
                if (!EnergyHelper.isFluxItem(stack) || EnergyHelper.getEnergyStored(stack) <= 0) continue;
                int drain = (int)Math.max((float)EnergyHelper.getEnergyStored(stack), (float)EnergyHelper.getMaxEnergyStored(stack) * percentualDrain);
                for (int hasDrained = 0; hasDrained < drain && (actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false)) > 0; hasDrained += actualDrain) {
                }
            }
        }
    }

    public void onExpire() {
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.setShort("xTile", (short)this.xTile);
        nbt.setShort("yTile", (short)this.yTile);
        nbt.setShort("zTile", (short)this.zTile);
        nbt.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.inTile));
        nbt.setInteger("inData", this.inData);
        nbt.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.setTag("direction", (NBTBase)this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbt.setString("bulletType", this.bulletType);
        if (!this.bulletPotion.isEmpty()) {
            nbt.setTag("bulletPotion", (NBTBase)this.bulletPotion.writeToNBT(new NBTTagCompound()));
        }
        if (this.shootingEntity != null) {
            nbt.setString("shootingEntity", this.shootingEntity.getName());
        }
    }

    protected void readEntityFromNBT(NBTTagCompound nbt) {
        this.xTile = nbt.getShort("xTile");
        this.yTile = nbt.getShort("yTile");
        this.zTile = nbt.getShort("zTile");
        this.inTile = Block.getBlockById((int)(nbt.getByte("inTile") & 0xFF));
        this.inData = nbt.getInteger("inData");
        this.inGround = nbt.getByte("inGround") == 1;
        this.bulletType = nbt.getString("bulletType");
        if (nbt.hasKey("bulletPotion")) {
            this.bulletPotion = new ItemStack(nbt.getCompoundTag("bulletPotion"));
        }
        if (nbt.hasKey("direction", 9)) {
            NBTTagList nbttaglist = nbt.getTagList("direction", 6);
            this.motionX = nbttaglist.getFloatAt(0);
            this.motionY = nbttaglist.getFloatAt(1);
            this.motionZ = nbttaglist.getFloatAt(2);
        } else {
            this.setDead();
        }
        if (this.world != null) {
            this.shootingEntity = this.world.getPlayerEntityByName(nbt.getString("shootingEntity"));
        }
    }

    public float getCollisionBorderSize() {
        return 1.0f;
    }

    public float getBrightness() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }
}

