/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityRailgunShot
extends EntityIEProjectile {
    private ItemStack ammo = ItemStack.EMPTY;
    private static final DataParameter<ItemStack> dataMarker_ammo = EntityDataManager.createKey(EntityRailgunShot.class, (DataSerializer)DataSerializers.ITEM_STACK);
    private RailgunHandler.RailgunProjectileProperties ammoProperties;

    public EntityRailgunShot(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
        this.pickupStatus = EntityArrow.PickupStatus.ALLOWED;
    }

    public EntityRailgunShot(World world, double x, double y, double z, double ax, double ay, double az, ItemStack ammo) {
        super(world, x, y, z, ax, ay, az);
        this.setSize(0.5f, 0.5f);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.pickupStatus = EntityArrow.PickupStatus.ALLOWED;
    }

    public EntityRailgunShot(World world, EntityLivingBase living, double ax, double ay, double az, ItemStack ammo) {
        super(world, living, ax, ay, az);
        this.setSize(0.5f, 0.5f);
        this.ammo = ammo;
        this.setAmmoSynced();
        this.pickupStatus = EntityArrow.PickupStatus.ALLOWED;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(dataMarker_ammo, (Object)ItemStack.EMPTY);
    }

    @Override
    protected ItemStack getArrowStack() {
        return this.ammo;
    }

    public void setAmmoSynced() {
        if (!this.getAmmo().isEmpty()) {
            this.dataManager.set(dataMarker_ammo, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return (ItemStack)this.dataManager.get(dataMarker_ammo);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public RailgunHandler.RailgunProjectileProperties getAmmoProperties() {
        if (this.ammoProperties == null && !this.ammo.isEmpty()) {
            this.ammoProperties = RailgunHandler.getProjectileProperties(this.ammo);
        }
        return this.ammoProperties;
    }

    @Override
    public double getGravity() {
        return 0.005 * (this.getAmmoProperties() != null ? this.getAmmoProperties().gravity : 1.0);
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void onEntityUpdate() {
        if (this.getAmmo().isEmpty() && this.world.isRemote) {
            this.ammo = this.getAmmoSynced();
        }
        super.onEntityUpdate();
    }

    @Override
    public void onImpact(RayTraceResult mop) {
        if (!(this.world.isRemote || this.getAmmo().isEmpty() || mop.entityHit == null || this.getAmmoProperties() == null || this.getAmmoProperties().overrideHitEntity(mop.entityHit, this.getShooter()))) {
            mop.entityHit.attackEntityFrom(IEDamageSources.causeRailgunDamage(this, this.getShooter()), (float)this.getAmmoProperties().damage * Config.IEConfig.Tools.railgun_damage);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        if (!this.ammo.isEmpty()) {
            nbt.setTag("ammo", (NBTBase)this.ammo.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.ammo = new ItemStack(nbt.getCompoundTag("ammo"));
    }
}

