/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityIEProjectile
extends EntityArrow {
    protected int blockX = -1;
    protected int blockY = -1;
    protected int blockZ = -1;
    protected Block inBlock;
    protected int inMeta;
    public boolean inGround;
    public int ticksInGround;
    public int ticksInAir;
    private int tickLimit = 40;
    private static final DataParameter<String> dataMarker_shooter = EntityDataManager.createKey(EntityIEProjectile.class, (DataSerializer)DataSerializers.STRING);

    public EntityIEProjectile(World world) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.pickupStatus = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityIEProjectile(World world, double x, double y, double z, double ax, double ay, double az) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
        this.setPosition(x, y, z);
        this.pickupStatus = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityIEProjectile(World world, EntityLivingBase living, double ax, double ay, double az) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(living.posX, living.posY + (double)living.getEyeHeight(), living.posZ, living.rotationYaw, living.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.motionX = ax;
        this.motionY = ay;
        this.motionZ = az;
        this.shootingEntity = living;
        this.setShooterSynced();
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, 3.0f, 1.0f);
        this.pickupStatus = EntityArrow.PickupStatus.DISALLOWED;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(dataMarker_shooter, (Object)"");
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.dataManager.set(dataMarker_shooter, (Object)this.shootingEntity.getName());
    }

    public EntityLivingBase getShooterSynced() {
        String s = (String)this.dataManager.get(dataMarker_shooter);
        if (s != null) {
            return this.world.getPlayerEntityByName(s);
        }
        return null;
    }

    public Entity getShooter() {
        return this.shootingEntity;
    }

    protected ItemStack getArrowStack() {
        return ItemStack.EMPTY;
    }

    public void onUpdate() {
        AxisAlignedBB axisalignedbb;
        if (this.getShooter() == null && this.world.isRemote) {
            this.shootingEntity = this.getShooterSynced();
        }
        this.onEntityUpdate();
        BlockPos blockpos = new BlockPos(this.blockX, this.blockY, this.blockZ);
        IBlockState iblockstate = this.world.getBlockState(blockpos);
        Block block = iblockstate.getBlock();
        if (iblockstate.getMaterial() != Material.AIR && (axisalignedbb = block.getCollisionBoundingBox(iblockstate, (IBlockAccess)this.world, blockpos)) != null && axisalignedbb.contains(new Vec3d(this.posX, this.posY, this.posZ))) {
            this.inGround = true;
        }
        if (this.inGround) {
            int j = block.getMetaFromState(iblockstate);
            if (block == this.inBlock && j == this.inMeta) {
                ++this.ticksInGround;
                if (this.ticksInGround >= this.getMaxTicksInGround()) {
                    this.setDead();
                }
            } else {
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir >= this.tickLimit) {
                this.setDead();
                return;
            }
            Vec3d currentPos = new Vec3d(this.posX, this.posY, this.posZ);
            Vec3d nextPos = new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            RayTraceResult mop = this.world.rayTraceBlocks(currentPos, nextPos, false, true, false);
            currentPos = new Vec3d(this.posX, this.posY, this.posZ);
            nextPos = mop != null ? new Vec3d(mop.hitVec.x, mop.hitVec.y, mop.hitVec.z) : new Vec3d(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            if (mop == null || mop.entityHit == null) {
                Entity entity = null;
                List list = this.world.getEntitiesInAABBexcluding((Entity)this, this.getEntityBoundingBox().expand(this.motionX, this.motionY, this.motionZ).grow(1.0), e -> e.canBeCollidedWith());
                double d0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double d1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.canBeCollidedWith() || entity1.isEntityEqual(this.shootingEntity) && this.ticksInAir <= 5) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb2 = entity1.getEntityBoundingBox().grow((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition1 = axisalignedbb2.calculateIntercept(currentPos, nextPos);
                    if (movingobjectposition1 == null || !((d1 = currentPos.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    mop = new RayTraceResult(entity);
                }
            }
            if (mop != null) {
                if (!this.isBurning() && this.canIgnite() && mop.entityHit != null && mop.entityHit.isBurning()) {
                    this.setFire(3);
                }
                if (mop.entityHit != null) {
                    boolean allowHit = true;
                    if (this.shootingEntity instanceof EntityPlayer && mop.entityHit instanceof EntityPlayer) {
                        allowHit = ((EntityPlayer)this.shootingEntity).canAttackPlayer((EntityPlayer)mop.entityHit);
                    }
                    if (allowHit) {
                        this.onImpact(mop);
                    }
                    this.setDead();
                } else if (mop.typeOfHit == RayTraceResult.Type.BLOCK) {
                    this.onImpact(mop);
                    this.blockX = mop.getBlockPos().getX();
                    this.blockY = mop.getBlockPos().getY();
                    this.blockZ = mop.getBlockPos().getZ();
                    IBlockState state = this.world.getBlockState(mop.getBlockPos());
                    this.inBlock = state.getBlock();
                    this.inMeta = this.inBlock.getMetaFromState(state);
                    this.motionX = mop.hitVec.x - this.posX;
                    this.motionY = mop.hitVec.y - this.posY;
                    this.motionZ = mop.hitVec.z - this.posZ;
                    float f2 = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    this.posX -= this.motionX / (double)f2 * (double)0.05f;
                    this.posY -= this.motionY / (double)f2 * (double)0.05f;
                    this.posZ -= this.motionZ / (double)f2 * (double)0.05f;
                    this.inGround = true;
                    if (this.inBlock.getMaterial(state) != Material.AIR) {
                        this.inBlock.onEntityCollidedWithBlock(this.world, mop.getBlockPos(), state, (Entity)this);
                    }
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float motion = MathHelper.sqrt((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, motion) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float movementDecay = this.getMotionDecayFactor();
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.world.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ, new int[0]);
                }
                movementDecay *= 0.8f;
            }
            this.motionX *= (double)movementDecay;
            this.motionY *= (double)movementDecay;
            this.motionZ *= (double)movementDecay;
            this.motionY -= this.getGravity();
            this.setPosition(this.posX, this.posY, this.posZ);
            this.doBlockCollisions();
        }
    }

    public void onCollideWithPlayer(EntityPlayer p_70100_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_70112_1_) {
        double d1 = this.getEntityBoundingBox().getAverageEdgeLength() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    public abstract void onImpact(RayTraceResult var1);

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setShort("xTile", (short)this.blockX);
        nbt.setShort("yTile", (short)this.blockY);
        nbt.setShort("zTile", (short)this.blockZ);
        nbt.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.inBlock));
        nbt.setByte("inMeta", (byte)this.inMeta);
        nbt.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        if (this.shootingEntity != null) {
            nbt.setString("shootingEntity", this.shootingEntity.getName());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.blockX = nbt.getShort("xTile");
        this.blockY = nbt.getShort("yTile");
        this.blockZ = nbt.getShort("zTile");
        this.inBlock = Block.getBlockById((int)(nbt.getByte("inTile") & 0xFF));
        boolean bl = this.inGround = nbt.getByte("inGround") == 1;
        if (this.world != null) {
            this.shootingEntity = this.world.getPlayerEntityByName(nbt.getString("shootingEntity"));
        }
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }
}

