/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.util.IEExplosion;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityIEExplosive
extends EntityTNTPrimed {
    float explosionPower;
    boolean explosionSmoke = true;
    boolean explosionFire = false;
    float explosionDropChance;
    public IBlockState block;
    String name;
    private static final DataParameter<Optional<IBlockState>> dataMarker_block = EntityDataManager.createKey(EntityIEExplosive.class, (DataSerializer)DataSerializers.OPTIONAL_BLOCK_STATE);
    private static final DataParameter<Integer> dataMarker_fuse = EntityDataManager.createKey(EntityIEExplosive.class, (DataSerializer)DataSerializers.VARINT);

    public EntityIEExplosive(World world) {
        super(world);
    }

    public EntityIEExplosive(World world, double x, double y, double z, EntityLivingBase igniter, IBlockState blockstate, float explosionPower) {
        super(world, x, y, z, igniter);
        this.explosionPower = explosionPower;
        this.block = blockstate;
        this.explosionDropChance = 1.0f / explosionPower;
        this.setBlockSynced();
    }

    public EntityIEExplosive(World world, BlockPos pos, EntityLivingBase igniter, IBlockState blockstate, float explosionPower) {
        this(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, igniter, blockstate, explosionPower);
    }

    public EntityIEExplosive setSmoking(boolean smoke) {
        this.explosionSmoke = smoke;
        return this;
    }

    public EntityIEExplosive setFlaming(boolean fire) {
        this.explosionFire = fire;
        return this;
    }

    public EntityIEExplosive setDropChance(float chance) {
        this.explosionDropChance = chance;
        return this;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(dataMarker_block, (Object)Optional.absent());
        this.dataManager.register(dataMarker_fuse, (Object)0);
    }

    public void setBlockSynced() {
        if (this.block != null) {
            this.dataManager.set(dataMarker_block, (Object)Optional.of((Object)this.block));
            this.dataManager.set(dataMarker_fuse, (Object)this.getFuse());
        }
    }

    public void getBlockSynced() {
        this.block = (IBlockState)((Optional)this.dataManager.get(dataMarker_block)).orNull();
        this.setFuse((Integer)this.dataManager.get(dataMarker_fuse));
    }

    public String getName() {
        ItemStack s;
        if (this.block != null && this.name == null && !(s = new ItemStack(this.block.getBlock(), 1, this.block.getBlock().getMetaFromState(this.block))).isEmpty() && s.getItem() != Items.AIR) {
            this.name = s.getDisplayName();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    protected void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
        tagCompound.setFloat("explosionPower", this.explosionPower);
        tagCompound.setBoolean("explosionSmoke", this.explosionSmoke);
        tagCompound.setBoolean("explosionFire", this.explosionFire);
        if (this.block != null) {
            tagCompound.setInteger("block", Block.getStateId((IBlockState)this.block));
        }
    }

    protected void readEntityFromNBT(NBTTagCompound tagCompound) {
        super.readEntityFromNBT(tagCompound);
        this.explosionPower = tagCompound.getFloat("explosionPower");
        this.explosionSmoke = tagCompound.getBoolean("explosionSmoke");
        this.explosionFire = tagCompound.getBoolean("explosionFire");
        if (tagCompound.hasKey("block")) {
            this.block = Block.getStateById((int)tagCompound.getInteger("block"));
        }
    }

    public void onUpdate() {
        if (this.world.isRemote && this.block == null) {
            this.getBlockSynced();
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
        }
        int newFuse = this.getFuse() - 1;
        this.setFuse(newFuse);
        if (newFuse-- <= 0) {
            IEExplosion explosion;
            this.setDead();
            if (!this.world.isRemote && !ForgeEventFactory.onExplosionStart((World)this.world, (Explosion)(explosion = new IEExplosion(this.world, (Entity)this, this.posX, this.posY + (double)(this.height / 16.0f), this.posZ, this.explosionPower, this.explosionFire, this.explosionSmoke).setDropChance(this.explosionDropChance)))) {
                explosion.doExplosionA();
                explosion.doExplosionB(true);
            }
        } else {
            this.handleWaterMovement();
            this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

