/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.items.ItemFluorescentTube;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFluorescentTube
extends Entity
implements ITeslaEntity {
    private static final DataParameter<Boolean> dataMarker_active = EntityDataManager.createKey(EntityFluorescentTube.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Float> dataMarker_r = EntityDataManager.createKey(EntityFluorescentTube.class, (DataSerializer)DataSerializers.FLOAT);
    private static final DataParameter<Float> dataMarker_g = EntityDataManager.createKey(EntityFluorescentTube.class, (DataSerializer)DataSerializers.FLOAT);
    private static final DataParameter<Float> dataMarker_b = EntityDataManager.createKey(EntityFluorescentTube.class, (DataSerializer)DataSerializers.FLOAT);
    private static final DataParameter<Float> dataMarker_angleHorizontal = EntityDataManager.createKey(EntityFluorescentTube.class, (DataSerializer)DataSerializers.FLOAT);
    private int timer = 0;
    public boolean active = false;
    public float[] rgb;
    boolean firstTick = true;
    public float angleHorizontal = 0.0f;
    public float tubeLength = 1.5f;

    public EntityFluorescentTube(World world, ItemStack tube, float angleVert) {
        this(world);
        this.rotationYaw = angleVert;
        this.rgb = ItemFluorescentTube.getRGB(tube);
    }

    public EntityFluorescentTube(World world) {
        super(world);
        this.setSize(this.tubeLength / 2.0f, 1.0f + this.tubeLength / 2.0f);
    }

    public void onUpdate() {
        super.onUpdate();
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
        }
        if (this.firstTick && !this.world.isRemote && this.rgb != null) {
            this.dataManager.set(dataMarker_r, (Object)Float.valueOf(this.rgb[0]));
            this.dataManager.set(dataMarker_g, (Object)Float.valueOf(this.rgb[1]));
            this.dataManager.set(dataMarker_b, (Object)Float.valueOf(this.rgb[2]));
            this.dataManager.set(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            this.firstTick = false;
        }
        if (this.timer > 0 && !this.world.isRemote) {
            --this.timer;
            if (this.timer <= 0) {
                this.dataManager.set(dataMarker_active, (Object)false);
            }
        }
        if (this.world.isRemote) {
            this.active = (Boolean)this.dataManager.get(dataMarker_active);
            this.rgb = new float[]{((Float)this.dataManager.get(dataMarker_r)).floatValue(), ((Float)this.dataManager.get(dataMarker_g)).floatValue(), ((Float)this.dataManager.get(dataMarker_b)).floatValue()};
            this.angleHorizontal = ((Float)this.dataManager.get(dataMarker_angleHorizontal)).floatValue();
        }
    }

    protected void entityInit() {
        this.dataManager.register(dataMarker_r, (Object)Float.valueOf(1.0f));
        this.dataManager.register(dataMarker_g, (Object)Float.valueOf(1.0f));
        this.dataManager.register(dataMarker_b, (Object)Float.valueOf(1.0f));
        this.dataManager.register(dataMarker_active, (Object)false);
        this.dataManager.register(dataMarker_angleHorizontal, (Object)Float.valueOf(0.0f));
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        NBTTagCompound comp = nbt.getCompoundTag("nbt");
        this.rgb = new float[]{comp.getFloat("r"), comp.getFloat("g"), comp.getFloat("b")};
        this.angleHorizontal = nbt.getFloat("angleHor");
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        NBTTagCompound comp = new NBTTagCompound();
        comp.setFloat("r", this.rgb[0]);
        comp.setFloat("g", this.rgb[1]);
        comp.setFloat("b", this.rgb[2]);
        nbt.setTag("nbt", (NBTBase)comp);
        nbt.setFloat("angleHor", this.angleHorizontal);
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.isDead && !this.world.isRemote) {
            ItemStack tube = new ItemStack((Item)IEContent.itemFluorescentTube);
            ItemFluorescentTube.setRGB(tube, this.rgb);
            EntityItem ent = new EntityItem(this.world, this.posX, this.posY, this.posZ, tube);
            this.world.spawnEntity((Entity)ent);
            this.setDead();
        }
        return super.attackEntityFrom(source, amount);
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public AxisAlignedBB getEntityBoundingBox() {
        return super.getEntityBoundingBox();
    }

    @Override
    public void onHit(TileEntity te, boolean lowPower) {
        if (te instanceof TileEntityTeslaCoil && ((TileEntityTeslaCoil)te).energyStorage.extractEnergy(1, false) > 0) {
            this.timer = 35;
            this.dataManager.set(dataMarker_active, (Object)true);
        }
    }

    public EnumActionResult applyPlayerInteraction(EntityPlayer player, Vec3d targetVec3, EnumHand hand) {
        if (Utils.isHammer(player.getHeldItem(hand))) {
            this.angleHorizontal += (float)(player.isSneaking() ? 10 : 1);
            this.angleHorizontal %= 360.0f;
            this.dataManager.set(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            return EnumActionResult.SUCCESS;
        }
        return super.applyPlayerInteraction(player, targetVec3, hand);
    }
}

