/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.IEFluid;
import com.google.common.base.Optional;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class EntityChemthrowerShot
extends EntityIEProjectile
implements ILightProvider {
    private FluidStack fluid;
    private static final DataParameter<Optional<FluidStack>> dataMarker_fluid = EntityDataManager.createKey(EntityChemthrowerShot.class, IEFluid.OPTIONAL_FLUID_STACK);

    public EntityChemthrowerShot(World world) {
        super(world);
    }

    public EntityChemthrowerShot(World world, double x, double y, double z, double ax, double ay, double az, FluidStack fluid) {
        super(world, x, y, z, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    public EntityChemthrowerShot(World world, EntityLivingBase living, double ax, double ay, double az, FluidStack fluid) {
        super(world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(dataMarker_fluid, (Object)Optional.absent());
    }

    public void setFluidSynced() {
        if (this.getFluid() != null) {
            this.dataManager.set(dataMarker_fluid, (Object)Optional.of((Object)this.getFluid()));
        }
    }

    public FluidStack getFluidSynced() {
        return (FluidStack)((Optional)this.dataManager.get(dataMarker_fluid)).orNull();
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid() != null) {
            FluidStack fluidStack = this.getFluid();
            boolean isGas = fluidStack.getFluid().isGaseous(fluidStack) || ChemthrowerHandler.isGas(fluidStack.getFluid());
            return (isGas ? 0.025f : 0.05f) * (float)(fluidStack.getFluid().getDensity(fluidStack) < 0 ? -1 : 1);
        }
        return super.getGravity();
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid() == null ? null : this.getFluid().getFluid());
    }

    public void onEntityUpdate() {
        IBlockState state;
        Block b;
        if (this.getFluid() == null && this.world.isRemote) {
            this.fluid = this.getFluidSynced();
        }
        if ((b = (state = this.world.getBlockState(new BlockPos(this.posX, this.posY, this.posZ))).getBlock()) != null && this.canIgnite() && (state.getMaterial() == Material.FIRE || state.getMaterial() == Material.LAVA)) {
            this.setFire(6);
        }
        super.onEntityUpdate();
    }

    public void setFire(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.setFire(seconds);
    }

    @Override
    public void onImpact(RayTraceResult mop) {
        if (!this.world.isRemote && this.getFluid() != null) {
            int tempDiff;
            int damage;
            boolean fire;
            FluidStack fluidStack = this.getFluid();
            Fluid fluid = fluidStack.getFluid();
            ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(fluid);
            boolean bl = fire = fluid.getTemperature(fluidStack) > 1000;
            if (effect != null) {
                ItemStack thrower = ItemStack.EMPTY;
                EntityPlayer shooter = (EntityPlayer)this.getShooter();
                if (shooter != null) {
                    thrower = shooter.getHeldItem(EnumHand.MAIN_HAND);
                }
                if (mop.typeOfHit == RayTraceResult.Type.ENTITY) {
                    effect.applyToEntity((EntityLivingBase)mop.entityHit, shooter, thrower, fluidStack);
                } else if (mop.typeOfHit == RayTraceResult.Type.BLOCK) {
                    effect.applyToBlock(this.world, mop, shooter, thrower, fluidStack);
                }
            } else if (mop.entityHit != null && fluid.getTemperature(fluidStack) > 500 && mop.entityHit.attackEntityFrom(DamageSource.LAVA, (float)(damage = Math.abs(tempDiff = fluid.getTemperature(fluidStack) - 300) / 500))) {
                mop.entityHit.hurtResistantTime = (int)((double)mop.entityHit.hurtResistantTime * 0.75);
            }
            if (mop.entityHit != null) {
                int f;
                int n = this.isBurning() ? this.fire : (f = fire ? 3 : 0);
                if (f > 0) {
                    mop.entityHit.setFire(f);
                    if (mop.entityHit.attackEntityFrom(DamageSource.IN_FIRE, 2.0f)) {
                        mop.entityHit.hurtResistantTime = (int)((double)mop.entityHit.hurtResistantTime * 0.75);
                    }
                }
            }
        }
    }

    @Nullable
    public Light provideLight() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light;
            int n = light = this.isBurning() ? 15 : fluidStack.getFluid().getLuminosity(fluidStack);
            if (light > 0) {
                return Light.builder().pos((Entity)this).radius(0.05f * (float)light).color(1.0f, 1.0f, 1.0f).build();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light = this.isBurning() ? 15 : fluidStack.getFluid().getLuminosity(fluidStack);
            int superBrightness = super.getBrightnessForRender();
            light = superBrightness & 0xFF00000 | light << 4;
            if (light > 0) {
                return Math.max(light, superBrightness);
            }
        }
        return super.getBrightnessForRender();
    }

    public float getBrightness() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light;
            int n = light = this.isBurning() ? 15 : fluidStack.getFluid().getLuminosity(fluidStack);
            if (light > 0) {
                return Math.max((float)light, super.getBrightness());
            }
        }
        return super.getBrightness();
    }
}

