/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.crafting.IngredientIngrStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeShapelessIngredient
extends ShapelessOreRecipe {
    int nbtCopyTargetSlot = -1;
    int toolDamageSlot = -1;

    public RecipeShapelessIngredient(ResourceLocation group, ItemStack result, Object ... recipe) {
        super(group, result, RecipeShapelessIngredient.wrapIngredients(recipe));
    }

    public RecipeShapelessIngredient(ResourceLocation group, ItemStack result, NonNullList<Ingredient> input) {
        super(group, input, result);
    }

    private static Object[] wrapIngredients(Object ... recipe) {
        Object[] out = new Object[recipe.length];
        for (int i = 0; i < recipe.length; ++i) {
            out[i] = recipe[i] instanceof IngredientStack ? new IngredientIngrStack((IngredientStack)recipe[i]) : recipe[i];
        }
        return out;
    }

    public RecipeShapelessIngredient setNBTCopyTargetRecipe(int slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public RecipeShapelessIngredient setToolDamageRecipe(int slot) {
        this.toolDamageSlot = slot;
        return this;
    }

    public ItemStack getCraftingResult(InventoryCrafting matrix) {
        if (this.nbtCopyTargetSlot >= 0 && this.nbtCopyTargetSlot < this.getIngredients().size()) {
            for (int i = 0; i < matrix.getSizeInventory(); ++i) {
                ItemStack slot = matrix.getStackInSlot(i);
                if (!((Ingredient)this.getIngredients().get(this.nbtCopyTargetSlot)).apply(slot)) continue;
                ItemStack out = this.output.copy();
                if (!matrix.getStackInSlot(this.nbtCopyTargetSlot).isEmpty() && matrix.getStackInSlot(this.nbtCopyTargetSlot).hasTagCompound()) {
                    out.setTagCompound(matrix.getStackInSlot(this.nbtCopyTargetSlot).getTagCompound().copy());
                }
                return out;
            }
        }
        return super.getCraftingResult(matrix);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList remains = super.getRemainingItems(inv);
        for (int i = 0; i < remains.size(); ++i) {
            ItemStack empty;
            ItemStack s = inv.getStackInSlot(i);
            ItemStack remain = (ItemStack)remains.get(i);
            if (this.toolDamageSlot >= 0 && this.toolDamageSlot < this.getIngredients().size()) {
                ItemStack tool = ItemStack.EMPTY;
                if (remain.isEmpty() && !s.isEmpty() && ((Ingredient)this.getIngredients().get(this.toolDamageSlot)).apply(s)) {
                    tool = s.copy();
                } else if (!remain.isEmpty() && ((Ingredient)this.getIngredients().get(this.toolDamageSlot)).apply(remain)) {
                    tool = remain;
                }
                if (!tool.isEmpty() && tool.getItem().isDamageable()) {
                    tool.setItemDamage(tool.getItemDamage() + 1);
                    if (tool.getItemDamage() > tool.getMaxDamage()) {
                        tool = ItemStack.EMPTY;
                    }
                    remains.set(i, (Object)tool);
                }
            }
            if (s.isEmpty() || !remain.isEmpty() || !(s.getItem() instanceof UniversalBucket) || (empty = ((UniversalBucket)s.getItem()).getEmpty()).isEmpty()) continue;
            remains.set(i, (Object)empty.copy());
        }
        return remains;
    }

    public boolean matches(InventoryCrafting matrix, World world) {
        ArrayList required = new ArrayList(this.getIngredients());
        for (int i = 0; i < matrix.getSizeInventory(); ++i) {
            ItemStack slot = matrix.getStackInSlot(i);
            if (slot.isEmpty()) continue;
            boolean inRecipe = false;
            Iterator iterator = required.iterator();
            while (iterator.hasNext()) {
                Ingredient next = (Ingredient)iterator.next();
                if (!next.apply(slot)) continue;
                inRecipe = true;
                iterator.remove();
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }
}

