/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.crafting.IngredientFluidStack;
import blusunrize.immersiveengineering.common.crafting.IngredientIngrStack;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.regex.Pattern;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeShapedIngredient
extends ShapedOreRecipe {
    NonNullList<Ingredient> ingredientsQuarterTurn;
    NonNullList<Ingredient> ingredientsEighthTurn;
    int[] nbtCopyTargetSlot = null;
    Pattern nbtCopyPredicate = null;
    int lastMatch = 0;
    static int[] eighthTurnMap = new int[]{3, -1, -1, 3, 0, -3, 1, 1, -3};

    public RecipeShapedIngredient(ResourceLocation group, ItemStack result, Object ... recipe) {
        super(group, result, RecipeShapedIngredient.wrapIngredients(recipe));
    }

    public RecipeShapedIngredient(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    private static Object[] wrapIngredients(Object ... recipe) {
        Object[] out = new Object[recipe.length];
        for (int i = 0; i < recipe.length; ++i) {
            out[i] = recipe[i] instanceof IngredientStack ? new IngredientIngrStack((IngredientStack)recipe[i]) : recipe[i];
        }
        return out;
    }

    public RecipeShapedIngredient allowQuarterTurn() {
        this.ingredientsQuarterTurn = NonNullList.withSize((int)this.getIngredients().size(), (Object)Ingredient.EMPTY);
        int maxH = this.height - 1;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                this.ingredientsQuarterTurn.set(w * this.height + (maxH - h), this.getIngredients().get(h * this.width + w));
            }
        }
        return this;
    }

    public RecipeShapedIngredient allowEighthTurn() {
        if (this.width != 3 || this.height != 3) {
            return this;
        }
        this.ingredientsEighthTurn = NonNullList.withSize((int)this.getIngredients().size(), (Object)Ingredient.EMPTY);
        int maxH = this.height - 1;
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                int i = h * this.width + w;
                this.ingredientsEighthTurn.set(i + eighthTurnMap[i], this.getIngredients().get(i));
            }
        }
        return this;
    }

    public RecipeShapedIngredient setNBTCopyTargetRecipe(int ... slot) {
        this.nbtCopyTargetSlot = slot;
        return this;
    }

    public RecipeShapedIngredient setNBTCopyPredicate(String pattern) {
        this.nbtCopyPredicate = Pattern.compile(pattern);
        return this;
    }

    public ItemStack getCraftingResult(InventoryCrafting matrix) {
        if (this.nbtCopyTargetSlot != null) {
            ItemStack out = this.output.copy();
            NBTTagCompound tag = out.hasTagCompound() ? out.getTagCompound() : new NBTTagCompound();
            for (int targetSlot : this.nbtCopyTargetSlot) {
                ItemStack s = matrix.getStackInSlot(targetSlot);
                if (s.isEmpty() || !s.hasTagCompound()) continue;
                tag = ItemNBTHelper.combineTags(tag, s.getTagCompound(), this.nbtCopyPredicate);
            }
            if (!tag.hasNoTags()) {
                out.setTagCompound(tag);
            }
            return out;
        }
        return super.getCraftingResult(matrix);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList remains = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        for (int i = 0; i < this.height * this.width; ++i) {
            IFluidHandlerItem handler;
            NonNullList matchedIngr;
            ItemStack s = inv.getStackInSlot(i);
            Object object = this.lastMatch == 1 ? this.ingredientsQuarterTurn : (matchedIngr = this.lastMatch == 2 ? this.ingredientsEighthTurn : this.input);
            if (!(matchedIngr.get(i) instanceof IngredientFluidStack)) continue;
            if (!s.isEmpty()) {
                remains.set(i, (Object)Utils.copyStackWithAmount(s, 1));
            }
            if ((handler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)remains.get(i)))) == null) continue;
            FluidStack fluid = ((IngredientFluidStack)((Object)matchedIngr.get(i))).getFluid();
            handler.drain(fluid.amount, true);
            remains.set(i, (Object)handler.getContainer());
        }
        return remains;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        if (this.checkMatchDo(inv, (NonNullList<Ingredient>)this.getIngredients(), startX, startY, mirror, false)) {
            this.lastMatch = 0;
            return true;
        }
        if (this.ingredientsQuarterTurn != null && this.checkMatchDo(inv, this.ingredientsQuarterTurn, startX, startY, mirror, true)) {
            this.lastMatch = 1;
            return true;
        }
        if (this.ingredientsEighthTurn != null && this.checkMatchDo(inv, this.ingredientsEighthTurn, startX, startY, mirror, false)) {
            this.lastMatch = 2;
            return true;
        }
        return false;
    }

    protected boolean checkMatchDo(InventoryCrafting inv, NonNullList<Ingredient> ingredients, int startX, int startY, boolean mirror, boolean rotate) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack slot;
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.EMPTY;
                if (!rotate) {
                    if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                        target = mirror ? (Ingredient)ingredients.get(this.width - subX - 1 + subY * this.width) : (Ingredient)ingredients.get(subX + subY * this.width);
                    }
                } else if (subX >= 0 && subY >= 0 && subX < this.height && subY < this.width) {
                    target = mirror ? (Ingredient)ingredients.get(this.height - subX - 1 + subY * this.width) : (Ingredient)ingredients.get(subY + subX * this.height);
                }
                if (target.apply(slot = inv.getStackInRowAndColumn(x, y))) continue;
                return false;
            }
        }
        return true;
    }
}

