/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeShaderBags
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean matches(InventoryCrafting inv, World world) {
        ItemStack stack = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (stack.isEmpty()) {
                if (IEContent.itemShaderBag.equals(stackInSlot.getItem()) && ItemNBTHelper.hasKey(stackInSlot, "rarity")) {
                    stack = stackInSlot;
                    continue;
                }
                return false;
            }
            return false;
        }
        return !stack.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            ItemStack output = new ItemStack((Item)IEContent.itemShaderBag, IEContent.itemShaderBag.equals(stackInSlot.getItem()) ? 2 : 1);
            EnumRarity next = ShaderRegistry.getLowerRarity(stackInSlot.getRarity());
            if (next == null) continue;
            ItemNBTHelper.setString(output, "rarity", next.toString());
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canFit(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack((Item)IEContent.itemShaderBag, 2);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

