/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipePowerpack
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean matches(InventoryCrafting inv, World world) {
        ItemStack powerpack = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (powerpack.isEmpty() && IEContent.itemPowerpack.equals(stackInSlot.getItem())) {
                powerpack = stackInSlot;
                continue;
            }
            if (armor.isEmpty() && this.isValidArmor(stackInSlot)) {
                armor = stackInSlot;
                continue;
            }
            return false;
        }
        if (!(powerpack.isEmpty() || armor.isEmpty() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            return true;
        }
        return !armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Powerpack") && powerpack.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack powerpack = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (powerpack.isEmpty() && IEContent.itemPowerpack.equals(stackInSlot.getItem())) {
                powerpack = stackInSlot;
                continue;
            }
            if (!armor.isEmpty() || !this.isValidArmor(stackInSlot)) continue;
            armor = stackInSlot;
        }
        if (!(powerpack.isEmpty() || armor.isEmpty() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            ItemStack output = armor.copy();
            ItemNBTHelper.setItemStack(output, "IE:Powerpack", powerpack.copy());
            return output;
        }
        if (!armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Powerpack")) {
            ItemStack output = armor.copy();
            ItemNBTHelper.remove(output, "IE:Powerpack");
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canFit(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack(IEContent.itemPowerpack, 1, 0);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Powerpack")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Powerpack"));
        }
        return remaining;
    }

    private boolean isValidArmor(ItemStack stack) {
        if (!(stack.getItem() instanceof ItemArmor) || ((ItemArmor)stack.getItem()).armorType != EntityEquipmentSlot.CHEST) {
            return false;
        }
        if (stack.getItem() == IEContent.itemPowerpack) {
            return false;
        }
        String regName = stack.getItem().getRegistryName().toString();
        for (String s : Config.IEConfig.Tools.powerpack_whitelist) {
            if (!regName.equals(s)) continue;
            return true;
        }
        for (String s : Config.IEConfig.Tools.powerpack_blacklist) {
            if (!regName.equals(s)) continue;
            return false;
        }
        return true;
    }
}

