/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeJerrycan
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean matches(InventoryCrafting inv, World world) {
        IFluidHandlerItem handler;
        FluidStack fs;
        ItemStack jerrycan = ItemStack.EMPTY;
        ItemStack container = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (jerrycan.isEmpty() && IEContent.itemJerrycan.equals(stackInSlot.getItem()) && FluidUtil.getFluidContained((ItemStack)stackInSlot) != null) {
                jerrycan = stackInSlot;
                continue;
            }
            if (container.isEmpty() && FluidUtil.getFluidHandler((ItemStack)stackInSlot) != null) {
                container = stackInSlot;
                continue;
            }
            return false;
        }
        return !jerrycan.isEmpty() && !container.isEmpty() && ((fs = (handler = FluidUtil.getFluidHandler((ItemStack)container)).drain(Integer.MAX_VALUE, false)) == null || fs.amount < handler.getTankProperties()[0].getCapacity() && fs.isFluidEqual(FluidUtil.getFluidContained((ItemStack)jerrycan)));
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack jerrycan = ItemStack.EMPTY;
        ItemStack container = ItemStack.EMPTY;
        FluidStack fs = null;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (jerrycan.isEmpty() && IEContent.itemJerrycan.equals(stackInSlot.getItem()) && FluidUtil.getFluidContained((ItemStack)stackInSlot) != null) {
                jerrycan = stackInSlot;
                fs = FluidUtil.getFluidContained((ItemStack)jerrycan);
                continue;
            }
            if (!container.isEmpty() || FluidUtil.getFluidHandler((ItemStack)stackInSlot) == null) continue;
            container = stackInSlot;
        }
        if (fs != null && !container.isEmpty()) {
            ItemStack newContainer = Utils.copyStackWithAmount(container, 1);
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)newContainer);
            int accepted = handler.fill(fs, false);
            if (accepted > 0) {
                handler.fill(fs, true);
                ItemNBTHelper.setInt(jerrycan, "jerrycanDrain", accepted);
            }
            return newContainer;
        }
        return ItemStack.EMPTY;
    }

    public boolean canFit(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack getRecipeOutput() {
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

