/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeFlareBullets
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean matches(InventoryCrafting inv, World world) {
        ItemStack bullet = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (bullet.isEmpty() && IEContent.itemBullet.equals(stackInSlot.getItem()) && "flare".equals(ItemNBTHelper.getString(stackInSlot, "bullet"))) {
                bullet = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        return !bullet.isEmpty() && !list.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        ItemStack bullet = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (bullet.isEmpty() && IEContent.itemBullet.equals(stackInSlot.getItem()) && "flare".equals(ItemNBTHelper.getString(stackInSlot, "bullet"))) {
                bullet = stackInSlot;
                int colour = ((IEItemInterfaces.IColouredItem)bullet.getItem()).getColourForIEItem(bullet, 1);
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (!Utils.isDye(stackInSlot)) continue;
            float[] afloat = EntitySheep.getDyeRgb((EnumDyeColor)EnumDyeColor.byDyeDamage((int)Utils.getDye(stackInSlot)));
            int r = (int)(afloat[0] * 255.0f);
            int g = (int)(afloat[1] * 255.0f);
            int b = (int)(afloat[2] * 255.0f);
            j += Math.max(r, Math.max(g, b));
            colourArray[0] = colourArray[0] + r;
            colourArray[1] = colourArray[1] + g;
            colourArray[2] = colourArray[2] + b;
            ++totalColourSets;
        }
        if (!bullet.isEmpty()) {
            ItemStack newBullet = Utils.copyStackWithAmount(bullet, 1);
            int r = colourArray[0] / totalColourSets;
            int g = colourArray[1] / totalColourSets;
            int b = colourArray[2] / totalColourSets;
            float colourMod = (float)j / (float)totalColourSets;
            float highestColour = Math.max(r, Math.max(g, b));
            r = (int)((float)r * colourMod / highestColour);
            g = (int)((float)g * colourMod / highestColour);
            b = (int)((float)b * colourMod / highestColour);
            int newColour = (r << 8) + g;
            newColour = (newColour << 8) + b;
            ItemNBTHelper.setInt(newBullet, "flareColour", newColour);
            return newBullet;
        }
        return ItemStack.EMPTY;
    }

    public boolean canFit(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack getRecipeOutput() {
        return BulletHandler.getBulletStack("flare");
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

