/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeEarmuffs
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean matches(InventoryCrafting inv, World world) {
        ItemStack earmuffs = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (earmuffs.isEmpty() && IEContent.itemEarmuffs.equals(stackInSlot.getItem())) {
                earmuffs = stackInSlot;
                continue;
            }
            if (armor.isEmpty() && stackInSlot.getItem() instanceof ItemArmor && ((ItemArmor)stackInSlot.getItem()).armorType == EntityEquipmentSlot.HEAD && !IEContent.itemEarmuffs.equals(stackInSlot.getItem())) {
                armor = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        if (!(earmuffs.isEmpty() || armor.isEmpty() && list.isEmpty())) {
            return true;
        }
        return !armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs") && earmuffs.isEmpty() && list.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack earmuffs = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (earmuffs.isEmpty() && IEContent.itemEarmuffs.equals(stackInSlot.getItem())) {
                earmuffs = stackInSlot;
                int colour = ((IEItemInterfaces.IColouredItem)earmuffs.getItem()).getColourForIEItem(earmuffs, 0);
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                float[] afloat = EntitySheep.getDyeRgb((EnumDyeColor)EnumDyeColor.byDyeDamage((int)Utils.getDye(stackInSlot)));
                int r = (int)(afloat[0] * 255.0f);
                int g = (int)(afloat[1] * 255.0f);
                int b = (int)(afloat[2] * 255.0f);
                j += Math.max(r, Math.max(g, b));
                colourArray[0] = colourArray[0] + r;
                colourArray[1] = colourArray[1] + g;
                colourArray[2] = colourArray[2] + b;
                ++totalColourSets;
                continue;
            }
            if (!armor.isEmpty() || !(stackInSlot.getItem() instanceof ItemArmor) || ((ItemArmor)stackInSlot.getItem()).armorType != EntityEquipmentSlot.HEAD || IEContent.itemEarmuffs.equals(stackInSlot.getItem())) continue;
            armor = stackInSlot;
        }
        if (!earmuffs.isEmpty()) {
            ItemStack output;
            if (totalColourSets > 1) {
                int r = colourArray[0] / totalColourSets;
                int g = colourArray[1] / totalColourSets;
                int b = colourArray[2] / totalColourSets;
                float colourMod = (float)j / (float)totalColourSets;
                float highestColour = Math.max(r, Math.max(g, b));
                r = (int)((float)r * colourMod / highestColour);
                g = (int)((float)g * colourMod / highestColour);
                b = (int)((float)b * colourMod / highestColour);
                int newColour = (r << 8) + g;
                newColour = (newColour << 8) + b;
                ItemNBTHelper.setInt(earmuffs, "IE:EarmuffColour", newColour);
            }
            if (!armor.isEmpty()) {
                output = armor.copy();
                ItemNBTHelper.setItemStack(output, "IE:Earmuffs", earmuffs.copy());
            } else {
                output = earmuffs.copy();
            }
            return output;
        }
        if (!armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs")) {
            ItemStack output = armor.copy();
            ItemNBTHelper.remove(output, "IE:Earmuffs");
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canFit(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack((Item)IEContent.itemBullet, 1, 10);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.isEmpty() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Earmuffs")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Earmuffs"));
        }
        return remaining;
    }
}

