/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipesBanners;
import net.minecraft.tileentity.BannerPattern;

public class RecipeBannerAdvanced
extends RecipesBanners.RecipeAddPattern {
    public static LinkedHashMap<BannerPattern, RecipeReference> advancedPatterns = new LinkedHashMap();

    public static void addAdvancedPatternRecipe(BannerPattern pattern, IngredientStack stack, int ... offset) {
        if (offset != null && offset.length > 0) {
            int[] slotOffset = new int[2];
            slotOffset[0] = offset[0];
            if (offset.length > 1) {
                slotOffset[1] = offset[1];
            }
            advancedPatterns.put(pattern, new RecipeReference(stack, slotOffset));
        } else {
            advancedPatterns.put(pattern, new RecipeReference(stack));
        }
    }

    @Nullable
    protected BannerPattern matchPatterns(InventoryCrafting invCrafting) {
        for (BannerPattern pattern : BannerPattern.values()) {
            if (!advancedPatterns.containsKey(pattern)) continue;
            RecipeReference ref = advancedPatterns.get(pattern);
            boolean matchesPattern = true;
            boolean hasIngr = false;
            boolean hasColour = false;
            for (int i = 0; i < invCrafting.getSizeInventory() && matchesPattern; ++i) {
                ItemStack itemstack = invCrafting.getStackInSlot(i);
                if (itemstack.isEmpty() || itemstack.getItem() == Items.BANNER) continue;
                if (Utils.isDye(itemstack)) {
                    if (hasColour) {
                        matchesPattern = false;
                        break;
                    }
                    hasColour = true;
                    continue;
                }
                if (hasIngr || !ref.ingredient.matchesItemStack(itemstack)) {
                    matchesPattern = false;
                    break;
                }
                if (ref.offsetToBanner[0] != 0 || ref.offsetToBanner[1] != 0) {
                    int w = invCrafting.getWidth();
                    int h = invCrafting.getHeight();
                    int bannerSlot = i - ref.offsetToBanner[0] - ref.offsetToBanner[1] * w;
                    if (i % w == 0 && ref.offsetToBanner[0] > 0 || i % w == w - 1 && ref.offsetToBanner[0] < 0 || i / h == 0 && ref.offsetToBanner[1] > 0 || i / h == h - 1 && ref.offsetToBanner[1] < 0 || bannerSlot < 0 || bannerSlot >= invCrafting.getSizeInventory()) {
                        matchesPattern = false;
                        break;
                    }
                    ItemStack bannerCheck = invCrafting.getStackInSlot(bannerSlot);
                    if (bannerCheck.isEmpty() || bannerCheck.getItem() != Items.BANNER) {
                        matchesPattern = false;
                        break;
                    }
                }
                hasIngr = true;
            }
            if (!hasIngr) {
                matchesPattern = false;
            }
            if (!matchesPattern) continue;
            return pattern;
        }
        return null;
    }

    private static class RecipeReference {
        IngredientStack ingredient;
        int[] offsetToBanner = new int[2];

        public RecipeReference(IngredientStack ingredient) {
            this.ingredient = ingredient;
        }

        public RecipeReference(IngredientStack ingredient, int[] offsetToBanner) {
            this.ingredient = ingredient;
            this.offsetToBanner = offsetToBanner;
        }
    }
}

