/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MixerRecipePotion
extends MixerRecipe {
    public final PotionType inputPotionType;

    public MixerRecipePotion(PotionType inputType) {
        super(new FluidStack(IEContent.fluidPotion, 1000), MixerRecipePotion.getFluidStackForType(inputType, 1000), new Object[0], 6400);
        this.inputPotionType = inputType;
    }

    public static FluidStack getFluidStackForType(PotionType type, int amount) {
        if (type == PotionTypes.WATER || type == null) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        FluidStack stack = new FluidStack(IEContent.fluidPotion, amount);
        stack.tag = new NBTTagCompound();
        stack.tag.setString("Potion", ((ResourceLocation)PotionType.REGISTRY.getNameForObject((Object)type)).toString());
        return stack;
    }

    @Override
    public FluidStack getFluidOutput(FluidStack input, NonNullList<ItemStack> components) {
        if (components.size() != 1) {
            return input;
        }
        if (input != null) {
            for (PotionHelper.MixPredicate mixPredicate : PotionHelper.POTION_TYPE_CONVERSIONS) {
                if (mixPredicate.input != this.inputPotionType || !mixPredicate.reagent.apply((ItemStack)components.get(0))) continue;
                return MixerRecipePotion.getFluidStackForType((PotionType)mixPredicate.output, input.amount);
            }
        }
        return input;
    }

    @Override
    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        if (fluid != null && fluid.containsFluid(this.fluidInput)) {
            for (PotionHelper.MixPredicate mixPredicate : PotionHelper.POTION_TYPE_CONVERSIONS) {
                if (mixPredicate.input != this.inputPotionType) continue;
                for (ItemStack stack : components) {
                    if (!mixPredicate.reagent.apply(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int[] getUsedSlots(FluidStack fluid, NonNullList<ItemStack> components) {
        for (int i = 0; i < components.size(); ++i) {
            if (((ItemStack)components.get(i)).isEmpty() || !PotionHelper.isReagent((ItemStack)((ItemStack)components.get(i)))) continue;
            return new int[]{i};
        }
        return new int[0];
    }
}

