/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class MetalPressUnpackingRecipe
extends MetalPressRecipe {
    private final int baseEnergy;
    private HashMap<ComparableItemStack, PackedDelegate> cache = new HashMap();

    public MetalPressUnpackingRecipe(ComparableItemStack mold, int energy) {
        super(ItemStack.EMPTY, ItemStack.EMPTY, mold, energy);
        this.baseEnergy = energy;
        MetalPressRecipe.deserializers.put("unpacking", nbt -> {
            ComparableItemStack comp = ComparableItemStack.readFromNBT(nbt.getCompoundTag("mapKey"));
            if (this.cache.containsKey(comp)) {
                return this.cache.get(comp);
            }
            PackedDelegate delegate = new PackedDelegate(comp, new ItemStack(nbt.getCompoundTag("output")), IngredientStack.readFromNBT(nbt.getCompoundTag("input")), ComparableItemStack.readFromNBT(nbt.getCompoundTag("mold")), nbt.getInteger("energy"));
            this.cache.put(comp, delegate);
            return delegate;
        });
    }

    @Override
    public boolean listInJEI() {
        return false;
    }

    @Override
    public boolean matches(ItemStack mold, ItemStack input) {
        return this.getOutputCached(input) != null;
    }

    @Override
    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input) {
        return this.getOutputCached(input);
    }

    private PackedDelegate getOutputCached(ItemStack input) {
        ComparableItemStack comp = new ComparableItemStack(input);
        if (this.cache.containsKey(comp)) {
            return this.cache.get(comp);
        }
        comp.copy();
        ItemStack out = MetalPressPackingRecipe.getPackedOutput(1, 1, input);
        int count = out.getCount();
        if (count != 4 && count != 9) {
            this.cache.put(comp, null);
            return null;
        }
        ItemStack rePacked = MetalPressPackingRecipe.getPackedOutput(count == 4 ? 2 : 3, count, out);
        if (rePacked.isEmpty() || !OreDictionary.itemMatches((ItemStack)input, (ItemStack)rePacked, (boolean)true)) {
            this.cache.put(comp, null);
            return null;
        }
        PackedDelegate delegate = new PackedDelegate(comp, out, Utils.copyStackWithAmount(input, 1), this.mold, this.baseEnergy);
        this.cache.put(comp, delegate);
        return delegate;
    }

    public static class PackedDelegate
    extends MetalPressRecipe {
        private final ComparableItemStack mapKey;

        public PackedDelegate(ComparableItemStack mapKey, ItemStack output, Object input, ComparableItemStack mold, int energy) {
            super(output, input, mold, energy);
            this.mapKey = mapKey;
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.setString("type", "unpacking");
            nbt.setTag("mapKey", (NBTBase)this.mapKey.writeToNBT(new NBTTagCompound()));
            nbt.setTag("output", (NBTBase)this.output.writeToNBT(new NBTTagCompound()));
            nbt.setTag("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
            nbt.setTag("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
            nbt.setInteger("energy", (int)((float)this.getTotalProcessEnergy() / energyModifier));
            return nbt;
        }
    }
}

