/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MetalPressPackingRecipe
extends MetalPressRecipe {
    private final int gridSize;
    private final int totalAmount;
    private final int baseEnergy;
    private HashMap<ComparableItemStack, PackedDelegate> cache = new HashMap();

    public MetalPressPackingRecipe(ComparableItemStack mold, int energy, int gridSize) {
        super(ItemStack.EMPTY, ItemStack.EMPTY, mold, energy);
        this.gridSize = gridSize;
        this.totalAmount = gridSize * gridSize;
        this.baseEnergy = energy;
        MetalPressRecipe.deserializers.put("packing" + this.totalAmount, nbt -> {
            ComparableItemStack comp = ComparableItemStack.readFromNBT(nbt.getCompoundTag("mapKey"));
            if (this.cache.containsKey(comp)) {
                return this.cache.get(comp);
            }
            PackedDelegate delegate = new PackedDelegate(comp, new ItemStack(nbt.getCompoundTag("output")), IngredientStack.readFromNBT(nbt.getCompoundTag("input")), ComparableItemStack.readFromNBT(nbt.getCompoundTag("mold")), nbt.getInteger("energy"));
            this.cache.put(comp, delegate);
            return delegate;
        });
    }

    @Override
    public boolean listInJEI() {
        return false;
    }

    @Override
    public boolean matches(ItemStack mold, ItemStack input) {
        return input.getCount() >= this.totalAmount && this.getOutputCached(input) != null;
    }

    @Override
    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input) {
        return this.getOutputCached(input);
    }

    private PackedDelegate getOutputCached(ItemStack input) {
        ComparableItemStack comp = new ComparableItemStack(input);
        if (this.cache.containsKey(comp)) {
            return this.cache.get(comp);
        }
        comp.copy();
        ItemStack out = MetalPressPackingRecipe.getPackedOutput(this.gridSize, this.totalAmount, input);
        if (out.isEmpty()) {
            this.cache.put(comp, null);
            return null;
        }
        PackedDelegate delegate = new PackedDelegate(comp, out, Utils.copyStackWithAmount(input, this.totalAmount), this.mold, this.baseEnergy);
        this.cache.put(comp, delegate);
        return delegate;
    }

    public static ItemStack getPackedOutput(int gridSize, int totalAmount, ItemStack stack) {
        InventoryCrafting invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (NonNullList<ItemStack>)NonNullList.withSize((int)totalAmount, (Object)stack.copy()));
        IRecipe recipe = Utils.findRecipe(invC, FMLCommonHandler.instance().getMinecraftServerInstance().getEntityWorld());
        if (recipe != null) {
            return recipe.getCraftingResult(invC);
        }
        return ItemStack.EMPTY;
    }

    public static class PackedDelegate
    extends MetalPressRecipe {
        private final ComparableItemStack mapKey;

        public PackedDelegate(ComparableItemStack mapKey, ItemStack output, Object input, ComparableItemStack mold, int energy) {
            super(output, input, mold, energy);
            this.mapKey = mapKey;
        }

        @Override
        public boolean listInJEI() {
            return false;
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.setString("type", "packing" + this.input.inputSize);
            nbt.setTag("mapKey", (NBTBase)this.mapKey.writeToNBT(new NBTTagCompound()));
            nbt.setTag("output", (NBTBase)this.output.writeToNBT(new NBTTagCompound()));
            nbt.setTag("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
            nbt.setTag("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
            nbt.setInteger("energy", (int)((float)this.getTotalProcessEnergy() / energyModifier));
            return nbt;
        }
    }
}

