/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class IngredientMultiOre
extends Ingredient {
    private NonNullList<ItemStack>[] ores;
    private IntList itemIds = null;
    private ItemStack[] array = null;

    public IngredientMultiOre(String ... ores) {
        super(0);
        this.ores = new NonNullList[ores.length];
        for (int i = 0; i < ores.length; ++i) {
            this.ores[i] = OreDictionary.getOres((String)ores[i]);
        }
    }

    private int totalSize() {
        int i = 0;
        for (NonNullList<ItemStack> list : this.ores) {
            i += list.size();
        }
        return i;
    }

    @Nonnull
    public ItemStack[] getMatchingStacks() {
        if (this.array == null || this.array.length != this.totalSize()) {
            NonNullList lst = NonNullList.create();
            for (NonNullList<ItemStack> list : this.ores) {
                for (ItemStack stack : list) {
                    if (stack.getMetadata() == Short.MAX_VALUE) {
                        stack.getItem().getSubItems(CreativeTabs.SEARCH, lst);
                        continue;
                    }
                    lst.add((Object)stack);
                }
            }
            this.array = (ItemStack[])lst.toArray((Object[])new ItemStack[lst.size()]);
        }
        return this.array;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IntList getValidItemStacksPacked() {
        if (this.itemIds == null || this.itemIds.size() != this.totalSize()) {
            this.itemIds = new IntArrayList(this.totalSize());
            for (NonNullList<ItemStack> list : this.ores) {
                for (ItemStack stack : list) {
                    if (stack.getMetadata() == Short.MAX_VALUE) {
                        NonNullList lst = NonNullList.create();
                        stack.getItem().getSubItems(CreativeTabs.SEARCH, lst);
                        for (ItemStack item : lst) {
                            this.itemIds.add(RecipeItemHelper.pack((ItemStack)item));
                        }
                        continue;
                    }
                    this.itemIds.add(RecipeItemHelper.pack((ItemStack)stack));
                }
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (NonNullList<ItemStack> list : this.ores) {
            for (ItemStack stack : list) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    protected void invalidate() {
        this.itemIds = null;
    }
}

