/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ArcRecyclingThreadHandler
extends Thread {
    static boolean hasProfiled = false;
    public static List<ArcFurnaceRecipe> recipesToAdd = null;
    private List<IRecipe> recipeList = null;

    private ArcRecyclingThreadHandler(List<IRecipe> r) {
        this.recipeList = r;
    }

    public static void doRecipeProfiling() {
        Iterator<ArcFurnaceRecipe> prevRecipeIt = ArcFurnaceRecipe.recipeList.iterator();
        int r = 0;
        if (hasProfiled) {
            while (prevRecipeIt.hasNext()) {
                ArcFurnaceRecipe recipe = prevRecipeIt.next();
                if (!"Recycling".equals(recipe.specialRecipeType)) continue;
                prevRecipeIt.remove();
                IECompatModule.jeiRemoveFunc.accept(recipe);
                ++r;
            }
        }
        IELogger.info("Arc Recycling: Removed " + r + " old recipes");
        recipesToAdd = null;
        new ArcRecyclingThreadHandler(ForgeRegistries.RECIPES.getValues()).start();
    }

    @Override
    public void run() {
        int threadAmount = Runtime.getRuntime().availableProcessors();
        IELogger.info("Starting recipe profiler for Arc Recycling, using " + threadAmount + " Threads");
        long timestamp = System.currentTimeMillis();
        RegistryIterationThread[] threads = new RegistryIterationThread[threadAmount];
        boolean divisable = this.recipeList.size() % threadAmount == 0;
        int limit = divisable ? this.recipeList.size() / threadAmount : this.recipeList.size() / (threadAmount - 1);
        int leftOver = divisable ? limit : this.recipeList.size() - (threadAmount - 1) * limit;
        for (int i = 0; i < threadAmount; ++i) {
            threads[i] = new RegistryIterationThread(this.recipeList, limit * i, i == threadAmount - 1 ? leftOver : limit);
        }
        ArrayList<RecyclingCalculation> validated = new ArrayList<RecyclingCalculation>();
        ArrayListMultimap nonValidated = ArrayListMultimap.create();
        int invalidCount = 0;
        for (int i = 0; i < threads.length; ++i) {
            RegistryIterationThread thread = threads[i];
            try {
                thread.join();
                for (RecyclingCalculation calc : thread.calculatedOutputs) {
                    if (calc.isValid()) {
                        validated.add(calc);
                        continue;
                    }
                    for (ItemStack s : calc.queriedSubcomponents) {
                        nonValidated.put((Object)s, (Object)calc);
                    }
                    ++invalidCount;
                }
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int timeout = 0;
        while (!nonValidated.isEmpty() && timeout++ < invalidCount * 10) {
            ArrayList<RecyclingCalculation> newlyValid = new ArrayList<RecyclingCalculation>();
            for (RecyclingCalculation valid : validated) {
                for (Map.Entry e : nonValidated.entries()) {
                    RecyclingCalculation nonValid;
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)e.getKey()), (ItemStack)valid.stack, (boolean)false) || !(nonValid = (RecyclingCalculation)e.getValue()).validateSubcomponent(valid)) continue;
                    newlyValid.add(nonValid);
                }
            }
            nonValidated.values().removeAll(newlyValid);
            validated.addAll(newlyValid);
        }
        HashSet<String> finishedRecycles = new HashSet<String>();
        ArrayList<ArcFurnaceRecipe> ret = new ArrayList<ArcFurnaceRecipe>();
        for (RecyclingCalculation valid : validated) {
            if (!finishedRecycles.add(valid.stack.toString()) || valid.outputs.isEmpty()) continue;
            ret.add(new ArcRecyclingRecipe(valid.outputs, valid.stack, 100, 512));
        }
        for (RecyclingCalculation invalid : Sets.newHashSet((Iterable)nonValidated.values())) {
            if (!finishedRecycles.add(invalid.stack.toString()) || invalid.outputs.isEmpty()) continue;
            ret.add(new ArcRecyclingRecipe(invalid.outputs, invalid.stack, 100, 512));
        }
        IELogger.info("Finished recipe profiler for Arc Recycling, took " + (System.currentTimeMillis() - timestamp) + " milliseconds");
        recipesToAdd = ret;
        hasProfiled = true;
    }

    public static boolean isValidForRecycling(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemArmor) {
            return true;
        }
        for (Object recycle : ArcFurnaceRecipe.recyclingAllowed) {
            if (!Utils.stackMatchesObject(stack, recycle)) continue;
            return true;
        }
        return false;
    }

    public static RecyclingCalculation getRecycleCalculation(ItemStack stack, IRecipe recipe) {
        NonNullList inputs = recipe.getIngredients();
        if (inputs != null) {
            int inputSize = stack.getCount();
            ArrayList<ItemStack> missingSub = new ArrayList<ItemStack>();
            HashMap<ItemStack, Double> outputs = new HashMap<ItemStack, Double>();
            for (Object in : inputs) {
                if (in == null) continue;
                ItemStack inputStack = ItemStack.EMPTY;
                if (in instanceof ItemStack) {
                    inputStack = (ItemStack)in;
                } else if (in instanceof List) {
                    List list = (List)in;
                    inputStack = list.size() > 0 ? (ItemStack)list.get(0) : ItemStack.EMPTY;
                } else if (in instanceof String) {
                    inputStack = IEApi.getPreferredOreStack((String)in);
                }
                if (inputStack.isEmpty()) continue;
                Object[] brokenDown = ApiUtils.breakStackIntoPreciseIngots(inputStack);
                if (brokenDown == null) {
                    if (!ArcRecyclingThreadHandler.isValidForRecycling(inputStack)) continue;
                    missingSub.add(inputStack);
                    continue;
                }
                if (brokenDown[0] == null || !(brokenDown[0] instanceof ItemStack) || brokenDown[1] == null || !((Double)brokenDown[1] > 0.0)) continue;
                boolean invalidOutput = false;
                for (Object invalid : ArcFurnaceRecipe.invalidRecyclingOutput) {
                    if (!Utils.stackMatchesObject((ItemStack)brokenDown[0], invalid)) continue;
                    invalidOutput = true;
                }
                if (invalidOutput) continue;
                boolean b = false;
                for (ItemStack storedOut : outputs.keySet()) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)brokenDown[0]), (ItemStack)storedOut, (boolean)false)) continue;
                    outputs.put(storedOut, outputs.get(storedOut) + (Double)brokenDown[1] / (double)inputSize);
                    b = true;
                }
                if (b) continue;
                outputs.put(Utils.copyStackWithAmount((ItemStack)brokenDown[0], 1), (Double)brokenDown[1] / (double)inputSize);
            }
            if (!outputs.isEmpty() || !missingSub.isEmpty()) {
                RecyclingCalculation calc = new RecyclingCalculation(recipe, Utils.copyStackWithAmount(stack, 1), outputs);
                calc.queriedSubcomponents.addAll(missingSub);
                return calc;
            }
        }
        return null;
    }

    public static class RecyclingCalculation {
        IRecipe recipe;
        ItemStack stack;
        HashMap<ItemStack, Double> outputs;
        ArrayList<ItemStack> queriedSubcomponents = new ArrayList();

        public RecyclingCalculation(IRecipe recipe, ItemStack stack, HashMap<ItemStack, Double> outputs) {
            this.recipe = recipe;
            this.stack = stack;
            this.outputs = outputs;
        }

        public boolean isValid() {
            return !this.outputs.isEmpty() && this.queriedSubcomponents.isEmpty();
        }

        public boolean validateSubcomponent(RecyclingCalculation calc) {
            if (this.isValid()) {
                return true;
            }
            if (!calc.isValid()) {
                return false;
            }
            Iterator<ItemStack> it = this.queriedSubcomponents.iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!OreDictionary.itemMatches((ItemStack)next, (ItemStack)calc.stack, (boolean)false)) continue;
                for (Map.Entry<ItemStack, Double> e : calc.outputs.entrySet()) {
                    boolean b = true;
                    for (ItemStack key : this.outputs.keySet()) {
                        if (!OreDictionary.itemMatches((ItemStack)key, (ItemStack)e.getKey(), (boolean)false)) continue;
                        this.outputs.put(key, this.outputs.get(key) + e.getValue());
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    this.outputs.put(e.getKey(), e.getValue());
                }
                it.remove();
            }
            return this.isValid();
        }
    }

    public static class RegistryIterationThread
    extends Thread {
        final List<IRecipe> recipeList;
        final int baseOffset;
        final int passes;
        ArrayList<RecyclingCalculation> calculatedOutputs = new ArrayList();

        public RegistryIterationThread(List<IRecipe> recipeList, int baseOffset, int passes) {
            this.setName("Immersive Engineering Registry Iteratoration Thread");
            this.setDaemon(true);
            this.start();
            this.recipeList = recipeList;
            this.baseOffset = baseOffset;
            this.passes = passes;
        }

        @Override
        public void run() {
            for (int pass = 0; pass < this.passes; ++pass) {
                RecyclingCalculation calc;
                IRecipe recipe = this.recipeList.get(this.baseOffset + pass);
                if (recipe.getRecipeOutput().isEmpty() || !ArcRecyclingThreadHandler.isValidForRecycling(recipe.getRecipeOutput()) || (calc = ArcRecyclingThreadHandler.getRecycleCalculation(recipe.getRecipeOutput(), recipe)) == null) continue;
                this.calculatedOutputs.add(calc);
            }
        }
    }
}

