/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityWoodenCrate
extends TileEntityIEBase
implements IIEInventory,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride,
ILootContainer {
    NonNullList<ItemStack> inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    public ResourceLocation lootTable;
    public String name;
    private NBTTagList enchantments;
    IItemHandler insertionHandler = new IEInventoryHandler(27, this);

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (nbt.hasKey("name")) {
            this.name = nbt.getString("name");
        }
        if (nbt.hasKey("enchantments")) {
            this.enchantments = nbt.getTagList("enchantments", 10);
        }
        if (!descPacket) {
            if (nbt.hasKey("lootTable", 8)) {
                this.lootTable = new ResourceLocation(nbt.getString("lootTable"));
            } else {
                this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 27);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.setString("name", this.name);
        }
        if (this.enchantments != null) {
            nbt.setTag("enchantments", (NBTBase)this.enchantments);
        }
        if (!descPacket) {
            if (this.lootTable != null) {
                nbt.setString("lootTable", this.lootTable.toString());
            } else {
                this.writeInv(nbt, false);
            }
        }
    }

    public void writeInv(NBTTagCompound nbt, boolean toItem) {
        boolean write = false;
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).isEmpty()) continue;
            if (toItem) {
                write = true;
            }
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setByte("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).writeToNBT(itemTag);
            invList.appendTag((NBTBase)itemTag);
        }
        if (!toItem || write) {
            nbt.setTag("inventory", (NBTBase)invList);
        }
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.name != null ? new TextComponentString(this.name) : new TextComponentTranslation(this.getBlockMetadata() == 0 ? "tile.immersiveengineering.wooden_device0.crate.name" : "tile.immersiveengineering.wooden_device0.reinforced_crate.name", new Object[0]);
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 3;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this;
    }

    @Override
    public void onGuiOpened(EntityPlayer player, boolean clientside) {
        if (this.lootTable != null && !clientside) {
            LootTable loottable = this.world.getLootTableManager().getLootTableFromLocation(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)this.world);
            if (player != null) {
                contextBuilder.withLuck(player.getLuck());
            }
            LootContext context = contextBuilder.build();
            Random rand = new Random();
            List list = loottable.generateLootForPools(rand, context);
            ArrayList listSlots = Lists.newArrayList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).isEmpty()) continue;
                listSlots.add(i);
            }
            Collections.shuffle(listSlots, rand);
            if (listSlots.isEmpty()) {
                return;
            }
            Utils.shuffleLootItems(list, listSlots.size(), rand);
            for (ItemStack itemstack : list) {
                int slot = (Integer)listSlots.remove(listSlots.size() - 1);
                this.inventory.set(slot, (Object)itemstack);
            }
            this.markDirty();
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.markDirty();
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeInv(tag, true);
        if (!tag.hasNoTags()) {
            stack.setTagCompound(tag);
        }
        if (this.name != null) {
            stack.setStackDisplayName(this.name);
        }
        if (this.enchantments != null) {
            ItemNBTHelper.getTag(stack).setTag("ench", (NBTBase)this.enchantments);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.hasTagCompound()) {
            this.readCustomNBT(stack.getTagCompound(), false);
            if (stack.hasDisplayName()) {
                this.name = stack.getDisplayName();
            }
            this.enchantments = stack.getEnchantmentTagList();
        }
    }

    @Override
    public boolean preventInventoryDrop() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory(this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.insertionHandler;
        }
        return super.getCapability(capability, facing);
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }
}

