/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalBarrel;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityWoodenBarrel
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride {
    public int[] sideConfig = new int[]{1, 0};
    public FluidTank tank = new FluidTank(12000);
    public static final int IGNITION_TEMPERATURE = 573;
    SidedFluidHandler[] sidedFluidHandler = new SidedFluidHandler[]{new SidedFluidHandler(this, EnumFacing.DOWN), new SidedFluidHandler(this, EnumFacing.UP)};
    SidedFluidHandler nullsideFluidHandler = new SidedFluidHandler(this, null);

    public void update() {
        if (this.world.isRemote) {
            return;
        }
        boolean update = false;
        for (int i = 0; i < 2; ++i) {
            IFluidHandler handler;
            int accepted;
            FluidStack drained;
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig[i] != 1) continue;
            EnumFacing f = EnumFacing.getFront((int)i);
            int out = Math.min(40, this.tank.getFluidAmount());
            TileEntity te = this.world.getTileEntity(this.getPos().offset(f));
            if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.getOpposite()) || (drained = this.tank.drain(accepted = (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.getOpposite())).fill(Utils.copyFluidStackWithAmount(this.tank.getFluid(), out, false), false), true)) == null) continue;
            handler.fill(drained, true);
            update = true;
        }
        if (update) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.getHeldItem(EnumHand.MAIN_HAND))) {
            String s = null;
            s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : I18n.format((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        if (hammer && Config.IEConfig.colourblindSupport && mop.sideHit.getAxis() == EnumFacing.Axis.Y) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.sideHit.getOpposite().ordinal())];
            return new String[]{I18n.format((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectFluid." + i), (Object[])new Object[0]), I18n.format((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.format((String)("desc.immersiveengineering.info.blockSide.connectFluid." + j), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 2) {
            this.sideConfig = new int[]{-1, 0};
        }
        this.readTank(nbt);
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        this.writeTank(nbt, false);
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.setTag("tank", (NBTBase)tankTag);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.getAxis() == EnumFacing.Axis.Y)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.getAxis() == EnumFacing.Axis.Y)) {
            return (T)(facing == null ? this.nullsideFluidHandler : this.sidedFluidHandler[facing.ordinal()]);
        }
        return super.getCapability(capability, facing);
    }

    public boolean isFluidValid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getTemperature(fluid) < 573 && !fluid.getFluid().isGaseous(fluid);
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        if (side > 1) {
            return IEEnums.SideConfig.NONE;
        }
        return IEEnums.SideConfig.values()[this.sideConfig[side] + 1];
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer p) {
        if (side != 0 && side != 1) {
            return false;
        }
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.markDirty();
        this.markContainingBlockForUpdate(null);
        this.world.addBlockEvent(this.getPos(), this.getBlockType(), 0, 0);
        return true;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)heldItem);
        boolean metal = this instanceof TileEntityMetalBarrel;
        if (f != null) {
            if (!metal && f.getFluid().isGaseous(f)) {
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.noGasAllowed", new Object[0])});
                return true;
            }
            if (!metal && f.getFluid().getTemperature(f) >= 573) {
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.tooHot", new Object[0])});
                return true;
            }
        }
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank)) {
            this.markDirty();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTank(tag, true);
        if (!tag.hasNoTags()) {
            stack.setTagCompound(tag);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.hasTagCompound()) {
            this.readTank(stack.getTagCompound());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return (int)(15.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        TileEntityWoodenBarrel barrel;
        EnumFacing facing;

        SidedFluidHandler(TileEntityWoodenBarrel barrel, EnumFacing facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || this.facing != null && this.barrel.sideConfig[this.facing.ordinal()] != 0 || !this.barrel.isFluidValid(resource)) {
                return 0;
            }
            int i = this.barrel.tank.fill(resource, doFill);
            if (i > 0) {
                this.barrel.markDirty();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.facing != null && this.barrel.sideConfig[this.facing.ordinal()] != 1) {
                return null;
            }
            FluidStack f = this.barrel.tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0) {
                this.barrel.markDirty();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return f;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.barrel.tank.getTankProperties();
        }
    }
}

