/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityWindmill
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHasObjProperty {
    public EnumFacing facing = EnumFacing.NORTH;
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;
    public float turnSpeed = 0.0f;
    public float perTick = 0.0f;
    public int sails = 0;
    public boolean canTurn = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static ArrayList<String> emptyDisplayList = new ArrayList();

    public void update() {
        TileEntity tileEntity;
        if (this.world.getTotalWorldTime() % 128L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x7F)) {
            this.canTurn = this.checkArea();
        }
        if (!this.canTurn) {
            return;
        }
        double mod = 5.0E-5;
        if (!this.world.isRaining()) {
            mod *= 0.75;
        }
        if (!this.world.isThundering()) {
            mod *= 0.66;
        }
        this.prevRotation = (float)((double)this.turnSpeed * (mod *= (double)this.getSpeedModifier()));
        this.rotation = (float)((double)this.rotation + (double)this.turnSpeed * mod);
        this.rotation %= 1.0f;
        this.perTick = (float)((double)this.turnSpeed * mod);
        if (!this.world.isRemote && (tileEntity = Utils.getExistingTileEntity(this.world, this.pos.offset(this.facing))) instanceof IRotationAcceptor) {
            IRotationAcceptor dynamo = (IRotationAcceptor)tileEntity;
            double power = (double)this.turnSpeed * mod * 800.0;
            dynamo.inputRotation(Math.abs(power), this.facing);
        }
    }

    protected float getSpeedModifier() {
        return 0.5f + (float)this.sails * 0.125f;
    }

    public boolean checkArea() {
        this.turnSpeed = 0.0f;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                if (hh == 0 && ww == 0 || this.world.isAirBlock(this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? ww : 0, hh, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : ww))) continue;
                return false;
            }
        }
        int blocked = 0;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                for (int dd = 1; dd < 8; ++dd) {
                    BlockPos pos = this.getPos().add(0, hh, 0).offset(this.facing.getOpposite(), dd).offset(this.facing.rotateY(), ww);
                    if (!this.world.isBlockLoaded(pos) || this.world.isAirBlock(pos)) {
                        this.turnSpeed += 1.0f;
                        continue;
                    }
                    if (this.world.getTileEntity(pos) instanceof TileEntityWindmill) {
                        blocked += 20;
                        this.turnSpeed -= 179.0f;
                        continue;
                    }
                    ++blocked;
                }
            }
            if (blocked <= 100) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.sails = nbt.getInteger("sails");
        this.rotation = nbt.getFloat("rotation");
        this.turnSpeed = nbt.getFloat("turnSpeed");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setInteger("sails", this.sails);
        nbt.setFloat("rotation", this.rotation);
        nbt.setFloat("turnSpeed", this.turnSpeed);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.getPos().getX() - (this.facing.getAxis() == EnumFacing.Axis.Z ? 6 : 0)), (double)(this.getPos().getY() - 6), (double)(this.getPos().getZ() - (this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 6)), (double)(this.getPos().getX() + (this.facing.getAxis() == EnumFacing.Axis.Z ? 7 : 0)), (double)(this.getPos().getY() + 7), (double)(this.getPos().getZ() + (this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 7)));
        }
        return this.renderAABB;
    }

    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 6;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return emptyDisplayList;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.sails < 8 && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 12), (ItemStack)heldItem, (boolean)false)) {
            ++this.sails;
            heldItem.shrink(1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        if (this.sails > 0) {
            ItemNBTHelper.setInt(stack, "sails", this.sails);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "sails")) {
            this.sails = ItemNBTHelper.getInt(stack, "sails");
        }
    }
}

