/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWatermill
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IHasObjProperty {
    public EnumFacing facing = EnumFacing.NORTH;
    public int[] offset = new int[]{0, 0};
    public float rotation = 0.0f;
    private Vec3d rotationVec = null;
    public boolean canTurn = false;
    public boolean multiblock = false;
    public float prevRotation = 0.0f;
    private boolean formed = true;
    public double perTick;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    static ArrayList<String> emptyDisplayList = new ArrayList();

    public void update() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.offset[0] != 0 || this.offset[1] != 0 || this.world == null) {
            return;
        }
        if (this.isBlocked()) {
            this.canTurn = false;
            return;
        }
        boolean bl = this.canTurn = this.multiblock || this.getRotationVec().lengthVector() != 0.0;
        if (this.world.getTotalWorldTime() % 64L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0x3F)) {
            this.rotationVec = null;
        }
        this.prevRotation = this.rotation;
        TileEntity acc = Utils.getExistingTileEntity(this.world, this.getPos().offset(this.facing.getOpposite()));
        if (!this.multiblock && acc instanceof IRotationAcceptor) {
            double power = this.getPower();
            int l = 1;
            TileEntity tileEntity = Utils.getExistingTileEntity(this.world, this.getPos().offset(this.facing, l));
            while (l < 3 && this.canUse(tileEntity)) {
                power += ((TileEntityWatermill)tileEntity).getPower();
                tileEntity = Utils.getExistingTileEntity(this.world, this.getPos().offset(this.facing, ++l));
            }
            this.perTick = 6.944444612599909E-4 * power / (double)l;
            this.canTurn = this.perTick != 0.0;
            this.rotation = (float)((double)this.rotation + this.perTick);
            this.rotation %= 1.0f;
            for (int l2 = 1; l2 < l; ++l2) {
                tileEntity = this.world.getTileEntity(this.getPos().offset(this.facing, l2));
                if (!(tileEntity instanceof TileEntityWatermill)) continue;
                ((TileEntityWatermill)tileEntity).rotation = this.rotation;
                ((TileEntityWatermill)tileEntity).canTurn = this.canTurn;
                ((TileEntityWatermill)tileEntity).perTick = this.perTick;
                ((TileEntityWatermill)tileEntity).multiblock = true;
            }
            if (!this.world.isRemote) {
                IRotationAcceptor dynamo = (IRotationAcceptor)acc;
                dynamo.inputRotation(Math.abs(power * 0.75), this.facing.getOpposite());
            }
        } else if (!this.multiblock) {
            this.perTick = 6.944444612599909E-4 * this.getPower();
            this.canTurn = this.perTick != 0.0;
            this.rotation = (float)((double)this.rotation + this.perTick);
            this.rotation %= 1.0f;
        }
        if (this.multiblock) {
            this.multiblock = false;
        }
    }

    private boolean canUse(@Nullable TileEntity tileEntity) {
        return tileEntity instanceof TileEntityWatermill && ((TileEntityWatermill)tileEntity).offset[0] == 0 && ((TileEntityWatermill)tileEntity).offset[1] == 0 && (((TileEntityWatermill)tileEntity).facing == this.facing || ((TileEntityWatermill)tileEntity).facing == this.facing.getOpposite()) && !((TileEntityWatermill)tileEntity).isBlocked() && !((TileEntityWatermill)tileEntity).multiblock;
    }

    public boolean isBlocked() {
        if (this.world == null) {
            return true;
        }
        for (EnumFacing fdY : new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN}) {
            EnumFacing[] enumFacingArray;
            if (this.facing.getAxis() == EnumFacing.Axis.Z) {
                EnumFacing[] enumFacingArray2 = new EnumFacing[2];
                enumFacingArray2[0] = EnumFacing.EAST;
                enumFacingArray = enumFacingArray2;
                enumFacingArray2[1] = EnumFacing.WEST;
            } else {
                EnumFacing[] enumFacingArray3 = new EnumFacing[2];
                enumFacingArray3[0] = EnumFacing.SOUTH;
                enumFacingArray = enumFacingArray3;
                enumFacingArray3[1] = EnumFacing.NORTH;
            }
            for (EnumFacing fdW : enumFacingArray) {
                BlockPos pos = this.getPos().offset(fdW, 2).offset(fdY, 2);
                IBlockState state = this.world.getBlockState(pos);
                if (state == null) {
                    return false;
                }
                if (state.isSideSolid((IBlockAccess)this.world, pos, fdW.getOpposite())) {
                    return true;
                }
                if (!state.isSideSolid((IBlockAccess)this.world, pos, fdY.getOpposite())) continue;
                return true;
            }
        }
        return false;
    }

    public double getPower() {
        return this.facing.getAxis() == EnumFacing.Axis.Z ? -this.getRotationVec().x : this.getRotationVec().z;
    }

    public void resetRotationVec() {
        this.rotationVec = null;
    }

    public Vec3d getRotationVec() {
        if (this.rotationVec == null) {
            this.rotationVec = new Vec3d(0.0, 0.0, 0.0);
            Vec3d dirHoz = this.getHorizontalVec();
            Vec3d dirVer = this.getVerticalVec();
            this.rotationVec = Utils.addVectors(this.rotationVec, dirHoz);
            this.rotationVec = Utils.addVectors(this.rotationVec, dirVer);
        }
        return this.rotationVec;
    }

    Vec3d getHorizontalVec() {
        Vec3d dir = new Vec3d(0.0, 0.0, 0.0);
        boolean faceZ = this.facing.ordinal() <= 3;
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.world, this.getPos().add(-(faceZ ? 1 : 0), 3, -(faceZ ? 0 : 1))));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.world, this.getPos().add(0, 3, 0)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.world, this.getPos().add(faceZ ? 1 : 0, 3, faceZ ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.world, this.getPos().add(-(faceZ ? 2 : 0), 2, -(faceZ ? 0 : 2))));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.world, this.getPos().add(faceZ ? 2 : 0, 2, faceZ ? 0 : 2)));
        dir = dir.subtract(Utils.getFlowVector(this.world, this.getPos().add(-(faceZ ? 2 : 0), -2, -(faceZ ? 0 : 2))));
        dir = dir.subtract(Utils.getFlowVector(this.world, this.getPos().add(faceZ ? 2 : 0, -2, faceZ ? 0 : 2)));
        dir = dir.subtract(Utils.getFlowVector(this.world, this.getPos().add(-(faceZ ? 1 : 0), -3, -(faceZ ? 0 : 1))));
        dir = dir.subtract(Utils.getFlowVector(this.world, this.getPos().add(0, -3, 0)));
        dir = dir.subtract(Utils.getFlowVector(this.world, this.getPos().add(faceZ ? 1 : 0, -3, faceZ ? 0 : 1)));
        return dir;
    }

    Vec3d getVerticalVec() {
        Vec3d dir = new Vec3d(0.0, 0.0, 0.0);
        Vec3d dirNeg = new Vec3d(0.0, 0.0, 0.0);
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.world, this.getPos().add(-(this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 0), 2, -(this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 2))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.world, this.getPos().add(-(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0), 1, -(this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.world, this.getPos().add(-(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0), 0, -(this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.world, this.getPos().add(-(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0), -1, -(this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3))));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.world, this.getPos().add(-(this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 0), -2, -(this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 2))));
        Vec3d dirPos = new Vec3d(0.0, 0.0, 0.0);
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.world, this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 0, 2, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 2)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.world, this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0, 1, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.world, this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0, 0, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.world, this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0, -1, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.world, this.getPos().add(this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 0, -2, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 2)));
        dir = this.facing.getAxis() == EnumFacing.Axis.Z ? dir.addVector(dirNeg.y - dirPos.y, 0.0, 0.0) : dir.addVector(0.0, 0.0, dirNeg.y - dirPos.y);
        return dir;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        this.rotationVec = new Vec3d((double)((float)id / 10000.0f), 0.0, (double)((float)arg / 10000.0f));
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.prevRotation = nbt.getFloat("prevRotation");
        this.offset = nbt.getIntArray("offset");
        this.rotation = nbt.getFloat("rotation");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setFloat("prevRotation", this.prevRotation);
        nbt.setIntArray("offset", this.offset);
        nbt.setFloat("rotation", this.rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offset[0] == 0 && this.offset[1] == 0 ? new AxisAlignedBB((double)(this.getPos().getX() - (this.facing.getAxis() == EnumFacing.Axis.Z ? 2 : 0)), (double)(this.getPos().getY() - 2), (double)(this.getPos().getZ() - (this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 2)), (double)(this.getPos().getX() + (this.facing.getAxis() == EnumFacing.Axis.Z ? 3 : 0)), (double)(this.getPos().getY() + 3), (double)(this.getPos().getZ() + (this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : 3))) : new AxisAlignedBB((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), (double)(this.getPos().getX() + 1), (double)(this.getPos().getY() + 1), (double)(this.getPos().getZ() + 1));
        }
        return this.renderAABB;
    }

    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 6;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2)) continue;
                BlockPos pos2 = pos.add(this.facing.getAxis() == EnumFacing.Axis.Z ? ww : 0, hh, this.facing.getAxis() == EnumFacing.Axis.Z ? 0 : ww);
                this.world.setBlockState(pos2, state);
                TileEntityWatermill dummy = (TileEntityWatermill)this.world.getTileEntity(pos2);
                dummy.facing = this.facing;
                dummy.offset = new int[]{ww, hh};
            }
        }
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (!this.formed) {
            return;
        }
        BlockPos initPos = pos.add(this.facing.getAxis() == EnumFacing.Axis.Z ? -this.offset[0] : 0, -this.offset[1], this.facing.getAxis() == EnumFacing.Axis.X ? -this.offset[0] : 0);
        for (int hh = -2; hh <= 2; ++hh) {
            for (int ww = -2; ww <= 2; ++ww) {
                BlockPos pos2;
                TileEntity te;
                if ((hh <= -2 || hh >= 2) && (ww <= -2 || ww >= 2) || !((te = this.world.getTileEntity(pos2 = initPos.add(this.facing.getAxis() == EnumFacing.Axis.Z ? ww : 0, hh, this.facing.getAxis() == EnumFacing.Axis.X ? ww : 0))) instanceof TileEntityWatermill)) continue;
                ((TileEntityWatermill)te).formed = false;
                this.world.setBlockToAir(pos2);
            }
        }
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return emptyDisplayList;
    }
}

