/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityTurntable
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.INeighbourChangeTile,
IEBlockInterfaces.IHammerInteraction {
    private EnumFacing facing = EnumFacing.UP;
    private boolean redstone = false;
    public boolean invert = false;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.redstone = nbt.getBoolean("redstone");
        this.invert = nbt.getBoolean("invert");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing.ordinal());
        nbt.setBoolean("redstone", this.redstone);
        nbt.setBoolean("invert", this.invert);
    }

    @Override
    public void onNeighborBlockChange(BlockPos pos) {
        boolean r = this.world.isBlockPowered(pos);
        if (r != this.redstone) {
            this.redstone = r;
            if (this.redstone) {
                BlockPos target = pos.offset(this.facing);
                RotationUtil.rotateBlock(this.world, target, this.invert ? this.facing : this.facing.getOpposite());
            }
        }
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 1;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return placer.isSneaking();
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.isSneaking();
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            this.invert = !this.invert;
            this.markDirty();
            this.world.addBlockEvent(this.getPos(), this.getBlockType(), 254, 0);
            return true;
        }
        return false;
    }
}

